/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.hud;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.util.ClientUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TerraStyleArmorHud
implements LayeredDraw.Layer {
    private static final int[] ARMOR = new int[]{0x979191, 14207049, 8427448, 3876692, 15359289};
    private static final int[] ARMOR_LOW = new int[]{6114123, 6574657, 5329527, 2103093, 0xB50000};
    private static final int[] ARMOR_HIGH = new int[]{0xFFFFEB, 16775607, 16177387, 5978990, 0xFFFFEB};

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!ClientConfigs.terraStyleArmor) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || !LibClientUtils.shouldDrawSurvivalElements((Minecraft)minecraft)) {
            return;
        }
        LibClientUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        minecraft.getProfiler().push("terra_style_hud");
        ClientConfigs.armorStyle.render(guiGraphics, minecraft);
        minecraft.getProfiler().pop();
    }

    public static enum Armor implements TranslatableEnum
    {
        LEGACY_HORIZONTAL{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                Armor.draw(guiGraphics, minecraft, 1);
            }
        }
        ,
        LEGACY_DIAGONAL{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                Armor.draw(guiGraphics, minecraft, 2);
            }
        }
        ,
        LEGACY_VERTICAL{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                Armor.draw(guiGraphics, minecraft, 3);
            }
        }
        ,
        OVERLAY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                float armor = 0.0f;
                LocalPlayer player = minecraft.player;
                if (player != null) {
                    armor = player.getArmorValue();
                }
                int widthArmor = guiGraphics.guiWidth() / 2 - 91;
                int heightArmor = guiGraphics.guiHeight() - minecraft.gui.leftHeight;
                minecraft.gui.leftHeight += 10;
                RandomSource random = RandomSource.create((long)59160153L);
                ClientUtils.colorDraw(guiGraphics, minecraft, random, ClientUtils.OVERLAY_TEXTURE, ARMOR, ARMOR_HIGH, ARMOR_LOW, armor, widthArmor, heightArmor, 128, 20, true);
            }
        };


        private static void draw(GuiGraphics guiGraphics, Minecraft minecraft, int type) {
            float widthOffset;
            int armorNum = 0;
            int armorToughnessNum = 0;
            LocalPlayer player = minecraft.player;
            if (player != null) {
                armorNum = player.getArmorValue();
                armorToughnessNum = (int)player.getAttribute(Attributes.ARMOR_TOUGHNESS).getValue();
            }
            String armor = Integer.toString(armorNum);
            String armorToughness = Integer.toString(armorToughnessNum);
            String text = switch (type) {
                case 1 -> "|";
                case 3 -> "-".repeat(Math.max(armor.length(), armorToughness.length()));
                default -> "/";
            };
            int widthArmor = guiGraphics.guiWidth() - 26;
            int heightArmor = guiGraphics.guiHeight() - 28;
            int textWidthArmor = minecraft.font.width((FormattedText)Component.literal((String)armor));
            int textWidthArmorToughness = minecraft.font.width((FormattedText)Component.literal((String)armorToughness));
            int textWidth = minecraft.font.width((FormattedText)Component.literal((String)text));
            Objects.requireNonNull(minecraft.font);
            int textHeight = 9;
            int colorWhite = 0xFFFFFF;
            int colorArmor = 15643476;
            int colorArmorToughness = 0x54E4EE;
            float v = (float)textWidthArmor * 0.5f;
            float v1 = (float)textWidth * 0.5f;
            float v2 = (float)textHeight * 0.5f;
            if (armorToughnessNum == 0) {
                widthOffset = 11.5f + v - 22.0f;
            } else {
                widthOffset = switch (type) {
                    case 1 -> 13.5f + v1 + (float)textWidthArmorToughness - 22.0f;
                    case 3 -> 11.5f + (float)Math.max(textWidthArmor, textWidthArmorToughness) * 0.5f - 22.0f;
                    default -> 11.5f + v1 + (float)textWidthArmorToughness - 22.0f;
                };
            }
            widthOffset = widthOffset > 0.0f ? widthOffset : 0.0f;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(-widthOffset, 0.0f, 0.0f);
            guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 0, 51, widthArmor, heightArmor, 23, 25);
            guiGraphics.pose().popPose();
            if (armorToughnessNum == 0) {
                ClientUtils.drawString(guiGraphics, minecraft.font, armor, (float)widthArmor + 11.5f - v - widthOffset, (float)heightArmor + 12.5f - v2, colorArmor);
            } else {
                ClientUtils.drawString(guiGraphics, minecraft.font, text, (float)widthArmor + 11.5f - v1 - widthOffset, (float)heightArmor + 12.5f - v2, colorWhite);
                switch (type) {
                    case 1: {
                        ClientUtils.drawString(guiGraphics, minecraft.font, armor, (float)widthArmor + 9.5f - v1 - (float)textWidthArmor - widthOffset, (float)heightArmor + 12.5f - v2, colorArmor);
                        ClientUtils.drawString(guiGraphics, minecraft.font, armorToughness, (float)widthArmor + 13.5f + v1 - widthOffset, (float)heightArmor + 12.5f - v2, colorArmorToughness);
                        break;
                    }
                    case 3: {
                        ClientUtils.drawString(guiGraphics, minecraft.font, armor, (float)widthArmor + 11.5f - v - widthOffset, (float)heightArmor + 10.5f - (float)textHeight, colorArmor);
                        ClientUtils.drawString(guiGraphics, minecraft.font, armorToughness, (float)widthArmor + 11.5f - (float)textWidthArmorToughness * 0.5f - widthOffset, (float)heightArmor + 14.5f, colorArmorToughness);
                        break;
                    }
                    default: {
                        ClientUtils.drawString(guiGraphics, minecraft.font, armor, (float)widthArmor + 11.5f - v1 - (float)textWidthArmor - widthOffset, (float)heightArmor + 9.5f - v2, colorArmor);
                        ClientUtils.drawString(guiGraphics, minecraft.font, armorToughness, (float)widthArmor + 11.5f + v1 - widthOffset, (float)heightArmor + 15.5f - v2, colorArmorToughness);
                    }
                }
            }
        }

        public abstract void render(GuiGraphics var1, Minecraft var2);

        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.armorStyle." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

