/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.hud;

import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.util.ClientUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TerraStyleSoulHud
implements LayeredDraw.Layer {
    private static final int[] SOUL = new int[]{10997993};
    private static final int[] SOUL_LOW = new int[]{7644610};
    private static final int[] SOUL_HIGH = new int[]{0xFEFFF9};

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || !LibClientUtils.shouldDrawSurvivalElements((Minecraft)minecraft)) {
            return;
        }
        LibClientUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        minecraft.getProfiler().push("terra_style_hud");
        ClientConfigs.soulStyle.render(guiGraphics, minecraft);
        minecraft.getProfiler().pop();
    }

    public static enum Soul implements TranslatableEnum
    {
        LEGACY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
            }
        }
        ,
        OVERLAY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                if (minecraft.player != null && !ClientPacketHandler.isFallenSoulCoreActive()) {
                    return;
                }
                float currentSoul = ClientPacketHandler.getCurrentSoul() / 5.0f;
                float maxSoul = (float)ClientPacketHandler.getMaxSoul() / 5.0f;
                int widthSoul = guiGraphics.guiWidth() / 2 + 10 + ClientConfigs.soulOffsetX;
                int heightSoul = guiGraphics.guiHeight() - minecraft.gui.rightHeight + ClientConfigs.soulOffsetY;
                minecraft.gui.rightHeight += 10;
                RandomSource random = RandomSource.create((long)1234329L);
                ClientUtils.colorDraw(guiGraphics, minecraft, random, ClientUtils.OVERLAY_TEXTURE, SOUL, SOUL_HIGH, SOUL_LOW, maxSoul, currentSoul, widthSoul, heightSoul, 128, 60, false);
            }
        };


        public abstract void render(GuiGraphics var1, Minecraft var2);

        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.soulStyle." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

