/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.StarPhase;
import org.confluence.mod.util.OverworldUtils;
import org.joml.Matrix4f;

public final class StarPhaseHandler {
    private static final ResourceLocation[] TEXTURES = (ResourceLocation[])Util.make((Object)new ResourceLocation[10], textures -> {
        textures[0] = Confluence.asResource("textures/stars/star_0_half_life.png");
        textures[1] = Confluence.asResource("textures/stars/star_1_warcraft.png");
        textures[2] = Confluence.asResource("textures/stars/star_2_pvz.png");
        textures[3] = Confluence.asResource("textures/stars/star_3_ut.png");
        textures[4] = Confluence.asResource("textures/stars/star_4_tetris.png");
        textures[5] = Confluence.asResource("textures/stars/star_5_stardew_valley.png");
        textures[6] = Confluence.asResource("textures/stars/star_6_dont_starve.png");
        textures[7] = Confluence.asResource("textures/stars/star_7_isaac.png");
        textures[8] = Confluence.asResource("textures/stars/star_8_super_mario.png");
        textures[9] = Confluence.asResource("textures/stars/star_9_pokemon.png");
    });
    private static final List<StarPhase> STAR_PHASES = (List)Util.make(new ArrayList(), map -> {
        for (int i = 0; i < 10; ++i) {
            map.add(StarPhase.DEFAULT);
        }
    });
    public static boolean enabled = false;

    public static void render(RenderLevelStageEvent event) {
        if (!enabled) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null || level.dimension() != OverworldUtils.dimension()) {
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        PoseStack poseStack = new PoseStack();
        poseStack.mulPose(event.getModelViewMatrix());
        float partialTick = minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        float gameTime = (float)(level.getGameTime() % 24000L) + partialTick;
        float dayTime = level.getTimeOfDay(partialTick);
        float rDay = dayTime * ((float)Math.PI * 2) + 1.5707964f;
        float alpha = 1.0f - level.getRainLevel(partialTick);
        float v1 = gameTime * 0.001f;
        float v2 = gameTime * 0.004166667f;
        float earthRa = 100.0f;
        float earthT = 400.0f;
        float invEarthT = 1.0f / earthT;
        float invSqrt = Mth.invSqrt((float)(earthRa * earthRa * earthRa * invEarthT)) * ((float)Math.PI / 180);
        float time = 1.0f;
        float sizeSet = 1.0f;
        float alphaX = dayTime * (float)Math.PI / 1200.0f;
        float alphaSet = (float)Math.pow(Mth.abs((float)Mth.sin((float)alphaX)), 0.1) * (Mth.sin((float)alphaX) / Mth.abs((float)(Mth.sin((float)alphaX) * 2.0f))) + 0.5f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha *= alphaSet));
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        for (int i = 0; i < 10; ++i) {
            StarPhase phase = STAR_PHASES.get(i);
            float timeOffset = phase.timeOffset();
            float radius = phase.radius();
            float size = sizeSet * (radius * 0.001f + timeOffset * 1.0E-4f + 0.07f / radius);
            poseStack.pushPose();
            float angle = phase.angle() * ((float)Math.PI / 180);
            float v = time * v2;
            float earthR = v * invSqrt;
            float starR = (v / Mth.sqrt((float)(radius * radius * radius * invEarthT)) + timeOffset) * ((float)Math.PI / 180) - earthR;
            float sin = Mth.sin((float)(starR + earthR));
            float cos = radius * Mth.cos((float)(sin * angle));
            float starX = cos * Mth.sin((float)starR);
            float starY = cos * Mth.cos((float)starR) - earthRa;
            float starZ = radius * sin * Mth.sin((float)angle);
            float dis = Mth.sqrt((float)(starX * starX + starY * starY));
            float disMax = radius + earthRa;
            float disMin = Mth.abs((float)(radius - earthRa));
            float trueDis = (dis - disMin) / (disMax - disMin) * 20.0f + 600.0f;
            float trueSize = size / dis * trueDis;
            poseStack.mulPose(Axis.ZP.rotation((float)Mth.atan2((double)starY, (double)starX)).rotateZ(rDay).rotateX((float)Mth.atan2((double)starZ, (double)dis)).rotateY(v1 + timeOffset));
            Matrix4f matrix4f = poseStack.last().pose();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES[i]);
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix4f, -trueSize, trueDis, -trueSize).setUv(0.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, trueSize, trueDis, -trueSize).setUv(1.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, trueSize, trueDis, trueSize).setUv(1.0f, 0.0f);
            bufferBuilder.addVertex(matrix4f, -trueSize, trueDis, trueSize).setUv(0.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            poseStack.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void handleStarPhases(Either<Int2ObjectMap<StarPhase>, Int2ObjectMap.Entry<StarPhase>> packet) {
        packet.ifLeft(map -> {
            STAR_PHASES.clear();
            for (int i = 0; i < 10; ++i) {
                STAR_PHASES.add((StarPhase)map.getOrDefault(i, (Object)StarPhase.DEFAULT));
            }
        }).ifRight(triple -> STAR_PHASES.set(triple.getIntKey(), (StarPhase)triple.getValue()));
    }
}

