/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler.bestiary;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function6;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.TranslatableEnum;
import net.neoforged.neoforge.resource.ContextAwareReloadListener;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.bestiary.RegisterBestiaryFilterEvent;
import org.confluence.mod.client.handler.bestiary.ClientBestiaryEntry;
import org.confluence.mod.client.handler.bestiary.FilterEntry;
import org.confluence.mod.common.data.saved.BestiaryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ClientBestiary
extends ContextAwareReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static ClientBestiary INSTANCE;
    private int unlockedCount;
    private boolean sortReversed = false;
    private SortType sortType = SortType.UNLOCKS;
    private Comparator<Map.Entry<String, ClientBestiaryEntry>> comparator;
    private Object2BooleanMap<FilterEntry> filterEntries;
    private Map<String, ClientBestiaryEntry> entries;
    private Map<String, ClientBestiaryEntry> backupEntries;
    private Map<String, ClientBestiaryEntry> sortedEntries;
    private CompletableFuture<SearchTree<Map.Entry<String, ClientBestiaryEntry>>> searchTree;
    private Level currentLevel;

    private ClientBestiary() {
        this.comparator = this.sortType.comparator;
        this.filterEntries = new Object2BooleanLinkedOpenHashMap();
        this.entries = Maps.newHashMap();
        this.backupEntries = Maps.newHashMap();
        this.sortedEntries = Maps.newLinkedHashMap();
        this.searchTree = CompletableFuture.completedFuture(SearchTree.empty());
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(this::apply, gameExecutor);
    }

    protected Map<String, JsonElement> prepare(ResourceManager resourceManager) {
        HashMap<String, JsonElement> map = new HashMap<String, JsonElement>();
        ResourceLocation resourceLocation = Confluence.asResource("bestiary.json");
        for (Resource resource : resourceManager.getResourceStack(resourceLocation)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject jsonobject = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    for (Map.Entry entry : jsonobject.entrySet()) {
                        map.put((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ioexception) {
                Confluence.LOGGER.error("Couldn't read {} in resource pack {}", new Object[]{resourceLocation, resource.sourcePackId(), ioexception});
            }
        }
        return map;
    }

    protected void apply(Map<String, JsonElement> resourceList) {
        HashMap map = Maps.newHashMap();
        HashMap backup = Maps.newHashMap();
        for (Map.Entry<String, JsonElement> entry : resourceList.entrySet()) {
            ClientBestiaryEntry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).ifSuccess(result -> {
                result.key = (String)entry.getKey();
                map.put(result.key, result);
                backup.put(result.key, result.copy());
            });
        }
        this.entries = map;
        this.backupEntries = backup;
        this.sortEntries();
    }

    public void registerCustomFilter() {
        ModLoader.postEvent((Event)new RegisterBestiaryFilterEvent((Function6<String, Integer, Integer, Integer, Integer, Integer, FilterEntry>)((Function6)FilterEntry::register)));
        Object2BooleanLinkedOpenHashMap map = new Object2BooleanLinkedOpenHashMap();
        FilterEntry.PRESETS.values().stream().sorted(Comparator.comparingInt(FilterEntry::getOrder)).forEachOrdered(arg_0 -> ClientBestiary.lambda$registerCustomFilter$2((Object2BooleanMap)map, arg_0));
        map.put((Object)FilterEntry.IF_UNLOCKED, false);
        this.filterEntries = map;
    }

    public Collection<FilterEntry> getFilterEntries() {
        return this.filterEntries.keySet();
    }

    public void toggleFilter(FilterEntry filter) {
        this.filterEntries.computeBooleanIfPresent((Object)filter, (entry, enabled) -> enabled == false);
        this.sortEntries();
    }

    public boolean isFilterEnabled(FilterEntry filter) {
        return this.filterEntries.getOrDefault((Object)filter, false);
    }

    public void setSortType(SortType type, boolean reverse) {
        this.sortType = type;
        this.sortReversed = reverse;
        this.comparator = reverse ? type.comparator.reversed() : type.comparator;
        this.sortEntries();
    }

    public boolean isSortReversed() {
        return this.sortReversed;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public Collection<ClientBestiaryEntry> search(String query) {
        if (query.isEmpty()) {
            return this.sortedEntries.values();
        }
        return this.searchTree.join().search(query).stream().sorted(this.comparator).map(Map.Entry::getValue).filter(this::filter).toList();
    }

    private void sortEntries() {
        LinkedHashMap sorted = Maps.newLinkedHashMap();
        this.entries.entrySet().stream().sorted(this.comparator).filter((? super T entry) -> this.filter((ClientBestiaryEntry)entry.getValue())).forEachOrdered(entry -> sorted.put((String)entry.getKey(), (ClientBestiaryEntry)entry.getValue()));
        this.sortedEntries = sorted;
        this.searchTree = CompletableFuture.supplyAsync(() -> SearchTree.plainText(this.sortedEntries.entrySet().stream().filter((? super T entry) -> !((ClientBestiaryEntry)entry.getValue()).isLocked()).toList(), entry -> Stream.of((String)entry.getKey(), ((ClientBestiaryEntry)entry.getValue()).getDescription().getString(), ((ClientBestiaryEntry)entry.getValue()).type.getDescription().getString()).map(s -> ChatFormatting.stripFormatting((String)s).trim())), Util.backgroundExecutor());
    }

    public int getUnlockedCount() {
        return this.unlockedCount;
    }

    private boolean filter(ClientBestiaryEntry entry) {
        if (entry.isLocked() && this.isFilterEnabled(FilterEntry.IF_UNLOCKED)) {
            return false;
        }
        List<FilterEntry> filters = entry.getFilters();
        if (filters.isEmpty()) {
            return true;
        }
        boolean enabled = false;
        for (FilterEntry filter : filters) {
            enabled |= this.isFilterEnabled(filter);
        }
        return enabled;
    }

    public Collection<ClientBestiaryEntry> getSortedEntries() {
        return this.sortedEntries.values();
    }

    public static ClientBestiary getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientBestiary();
        }
        return INSTANCE;
    }

    public static void reset() {
        ClientBestiary.getInstance().resetEntries();
    }

    private void resetEntries() {
        if (this.currentLevel == null) {
            return;
        }
        this.currentLevel = null;
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, ClientBestiaryEntry> entry : this.backupEntries.entrySet()) {
            entry.getValue().resetRenderedEntity();
            map.put(entry.getKey(), entry.getValue().copy());
        }
        this.entries = map;
        this.sortEntries();
    }

    public void handle(Either<Map<String, BestiaryEntry>, String> either) {
        either.ifLeft(map -> {
            boolean shouldCount = false;
            for (Map.Entry entry : map.entrySet()) {
                BestiaryEntry be = (BestiaryEntry)entry.getValue();
                ClientBestiaryEntry cbe = this.entries.computeIfAbsent((String)entry.getKey(), key -> {
                    ClientBestiaryEntry unknown = new ClientBestiaryEntry();
                    unknown.type = be.type;
                    unknown.key = key;
                    return unknown;
                });
                shouldCount |= cbe.unlock();
                cbe.killedByCount = be.killedByCount;
                cbe.maxHealth = be.maxHealth;
                cbe.knockbackResistance = be.knockbackResistance;
                cbe.attackDamage = be.attackDamage;
                cbe.armor = be.armor;
                cbe.drops = be.drops;
            }
            this.sortEntries();
            if (shouldCount) {
                int count = 0;
                for (ClientBestiaryEntry entry : this.entries.values()) {
                    if (entry.isLocked()) continue;
                    ++count;
                }
                this.unlockedCount = count;
            }
        }).ifRight(key -> {
            ClientBestiaryEntry entry = this.entries.get(key);
            if (entry != null) {
                ++entry.killedByCount;
            }
        });
    }

    private static /* synthetic */ void lambda$registerCustomFilter$2(Object2BooleanMap map, FilterEntry filter) {
        map.put((Object)filter, true);
    }

    public static enum SortType implements TranslatableEnum
    {
        UNLOCKS(Comparator.comparingInt(entry -> ((ClientBestiaryEntry)entry.getValue()).isLocked() ? 1 : 0)),
        BESTIARY_ID(Comparator.comparingInt(entry -> ((ClientBestiaryEntry)entry.getValue()).getOrder())),
        NAME(Comparator.comparing(entry -> ((ClientBestiaryEntry)entry.getValue()).getDescription().getString())),
        ATTACK(Comparator.comparingDouble(entry -> ((ClientBestiaryEntry)entry.getValue()).attackDamage)),
        DEFENSE(Comparator.comparingDouble(entry -> ((ClientBestiaryEntry)entry.getValue()).armor)),
        COINS(Comparator.comparingInt(entry -> ((ClientBestiaryEntry)entry.getValue()).drops)),
        HP(Comparator.comparingDouble(entry -> ((ClientBestiaryEntry)entry.getValue()).maxHealth)),
        RARITY(Comparator.comparingInt(entry -> ((ClientBestiaryEntry)entry.getValue()).getRarity()));

        private final Comparator<Map.Entry<String, ClientBestiaryEntry>> comparator;

        private SortType(Comparator<Map.Entry<String, ClientBestiaryEntry>> comparator) {
            this.comparator = comparator;
        }

        public Component getTranslatedName() {
            return Component.translatable((String)("bestiary.sort_type." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

