/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler.bestiary;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FilterEntry {
    static final Map<String, FilterEntry> PRESETS = Maps.newHashMap();
    public static final Codec<FilterEntry> CODEC = Codec.STRING.xmap(PRESETS::get, FilterEntry::name);
    public static final FilterEntry SURFACE = FilterEntry.register("surface", 0, 3, 1, 10, 13);
    public static final FilterEntry UNDERGROUND = FilterEntry.register("underground", 10, 17, 4, 12, 9);
    public static final FilterEntry CAVE = FilterEntry.register("cave", 20, 32, 1, 13, 12);
    public static final FilterEntry DESERT = FilterEntry.register("desert", 30, 48, 1, 9, 12);
    public static final FilterEntry UNDERGROUND_DESERT = FilterEntry.register("underground_desert", 40, 62, 2, 13, 12);
    public static final FilterEntry SNOW = FilterEntry.register("snow", 50, 77, 1, 12, 14);
    public static final FilterEntry UNDERGROUND_SNOW = FilterEntry.register("underground_snow", 60, 92, 1, 13, 13);
    public static final FilterEntry THE_CORRUPTION = FilterEntry.register("the_corruption", 70, 107, 2, 12, 11);
    public static final FilterEntry UNDERGROUND_CORRUPTION = FilterEntry.register("underground_corruption", 80, 122, 1, 13, 13);
    public static final FilterEntry CORRUPT_DESERT = FilterEntry.register("corrupt_desert", 90, 138, 2, 9, 12);
    public static final FilterEntry CORRUPT_CAVE_DESERT = FilterEntry.register("corrupt_cave_desert", 100, 152, 2, 13, 12);
    public static final FilterEntry CORRUPT_ICE = FilterEntry.register("corrupt_ice", 110, 167, 1, 13, 13);
    public static final FilterEntry THE_CRIMSON = FilterEntry.register("the_crimson", 120, 183, 2, 10, 12);
    public static final FilterEntry UNDERGROUND_CRIMSON = FilterEntry.register("underground_crimson", 130, 196, 1, 14, 13);
    public static final FilterEntry CRIMSON_DESERT = FilterEntry.register("crimson_desert", 140, 212, 1, 11, 12);
    public static final FilterEntry CRIMSON_CAVE_DESERT = FilterEntry.register("crimson_cave_desert", 150, 227, 1, 13, 12);
    public static final FilterEntry CRIMSON_ICE = FilterEntry.register("crimson_ice", 160, 1, 16, 13, 13);
    public static final FilterEntry THE_HALLOW = FilterEntry.register("the_hallow", 170, 16, 16, 14, 14);
    public static final FilterEntry UNDERGROUND_HALLOW = FilterEntry.register("underground_hallow", 180, 30, 18, 15, 12);
    public static final FilterEntry HALLOW_DESERT = FilterEntry.register("hallow_desert", 190, 48, 17, 9, 12);
    public static final FilterEntry HALLOW_CAVE_DESERT = FilterEntry.register("hallow_cave_desert", 200, 62, 17, 13, 12);
    public static final FilterEntry HALLOW_ICE = FilterEntry.register("hallow_ice", 210, 77, 17, 13, 13);
    public static final FilterEntry THE_JUNGLE = FilterEntry.register("the_jungle", 220, 92, 17, 12, 13);
    public static final FilterEntry UNDERGROUND_JUNGLE = FilterEntry.register("underground_jungle", 230, 107, 17, 13, 13);
    public static final FilterEntry SURFACE_MUSHROOM = FilterEntry.register("surface_mushroom", 240, 123, 17, 10, 13);
    public static final FilterEntry UNDERGROUND_MUSHROOM = FilterEntry.register("underground_mushroom", 250, 137, 18, 12, 12);
    public static final FilterEntry SKY = FilterEntry.register("sky", 260, 151, 16, 15, 14);
    public static final FilterEntry OCEAN = FilterEntry.register("ocean", 280, 184, 17, 8, 12);
    public static final FilterEntry MARBLE = FilterEntry.register("marble", 290, 198, 17, 10, 13);
    public static final FilterEntry GRANITE = FilterEntry.register("granite", 300, 213, 17, 10, 13);
    public static final FilterEntry THE_TEMPLE = FilterEntry.register("the_temple", 310, 227, 17, 13, 12);
    public static final FilterEntry THE_DUNGEON = FilterEntry.register("the_dungeon", 320, 2, 32, 12, 12);
    public static final FilterEntry THE_NETHER = FilterEntry.register("the_nether", 330, 17, 32, 12, 13);
    public static final FilterEntry SPIDER_NEST = FilterEntry.register("spider_nest", 340, 31, 33, 14, 12);
    public static final FilterEntry GRAVEYARD = FilterEntry.register("graveyard", 350, 48, 33, 11, 11);
    public static final FilterEntry DAYTIME = FilterEntry.register("daytime", 360, 62, 32, 12, 12);
    public static final FilterEntry NIGHTTIME = FilterEntry.register("nighttime", 370, 77, 33, 12, 11);
    public static final FilterEntry BLOOD_MOON = FilterEntry.register("blood_moon", 380, 93, 33, 11, 11);
    public static final FilterEntry ECLIPSE = FilterEntry.register("eclipse", 390, 107, 32, 12, 12);
    public static final FilterEntry RAIN = FilterEntry.register("rain", 400, 121, 32, 13, 11);
    public static final FilterEntry WINDY_DAY = FilterEntry.register("windy_day", 410, 136, 31, 14, 13);
    public static final FilterEntry BLIZZARD = FilterEntry.register("blizzard", 420, 151, 31, 14, 14);
    public static final FilterEntry SANDSTORM = FilterEntry.register("sandstorm", 430, 167, 33, 12, 12);
    public static final FilterEntry METEOR = FilterEntry.register("meteor", 440, 182, 33, 13, 12);
    public static final FilterEntry HALLOWEEN = FilterEntry.register("halloween", 450, 198, 33, 11, 11);
    public static final FilterEntry CHRISTMAS = FilterEntry.register("christmas", 460, 213, 32, 10, 12);
    public static final FilterEntry PARTY = FilterEntry.register("party", 480, 3, 46, 11, 14);
    public static final FilterEntry GOBLIN_INVASION = FilterEntry.register("goblin_invasion", 490, 17, 47, 13, 12);
    public static final FilterEntry PIRATE_INVASION = FilterEntry.register("pirate_invasion", 500, 32, 47, 12, 12);
    public static final FilterEntry PUMPKIN_MOON = FilterEntry.register("pumpkin_moon", 510, 48, 48, 11, 11);
    public static final FilterEntry FROST_MOON = FilterEntry.register("frost_moon", 520, 63, 48, 11, 11);
    public static final FilterEntry MARTIAN_MADNESS = FilterEntry.register("martian_madness", 530, 77, 47, 13, 12);
    public static final FilterEntry FROST_LEGION = FilterEntry.register("frost_legion", 540, 94, 47, 10, 12);
    public static final FilterEntry OLD_ONES_ARMY = FilterEntry.register("old_ones_army", 550, 107, 47, 13, 12);
    public static final FilterEntry SOLAR_PILLAR = FilterEntry.register("solar_pillar", 560, 122, 47, 12, 13);
    public static final FilterEntry VORTEX_PILLAR = FilterEntry.register("vortex_pillar", 570, 137, 47, 12, 13);
    public static final FilterEntry NEBULA_PILLAR = FilterEntry.register("nebula_pillar", 580, 152, 47, 12, 13);
    public static final FilterEntry STARDUST_PILLAR = FilterEntry.register("stardust_pillar", 590, 167, 47, 12, 13);
    public static final FilterEntry IF_UNLOCKED = FilterEntry.register("if_unlocked", 620, 213, 46, 10, 14);
    public static final FilterEntry BOSS_ENEMY = FilterEntry.register("boss_enemy", 630, 227, 47, 13, 13);
    public static final FilterEntry RARE_CREATURE = FilterEntry.register("rare_creature", 660, 31, 61, 14, 14);
    public static final FilterEntry UNKNOWN = new FilterEntry("unknown", 640, 4, 62, 9, 13);
    private final String name;
    private final int order;
    private final int u;
    private final int v;
    private final int w;
    private final int h;
    @Nullable
    public ResourceLocation sprite;
    private transient List<Component> tooltip;

    private FilterEntry(String name, int order, int u, int v, int w, int h) {
        this.name = name;
        this.order = order;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
    }

    static FilterEntry register(String name, int order, int u, int v, int w, int h) {
        FilterEntry entry = new FilterEntry(name, order, u, v, w, h);
        PRESETS.put(name, entry);
        return entry;
    }

    public String name() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public int u() {
        return this.u;
    }

    public int v() {
        return this.v;
    }

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public List<Component> tooltip() {
        if (this.tooltip == null) {
            this.tooltip = List.of(Component.translatable((String)("bestiary.confluence.filter." + this.name + ".title")), Component.translatable((String)("bestiary.confluence.filter." + this.name + ".desc")));
        }
        return this.tooltip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FilterEntry)) return false;
        FilterEntry entry = (FilterEntry)obj;
        if (!this.name.equals(entry.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "FilterEntry{name='" + this.name + "'}";
    }
}

