/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.model.block;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.common.RelicBlock;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import software.bernie.geckolib.model.GeoModel;

public class RelicBlockModel
extends GeoModel<RelicBlock.BEntity> {
    public static final Map<Block, ResourceLocation[]> CACHE = (Map)Util.make(new IdentityHashMap(), map -> {
        for (DeferredBlock<RelicBlock> block : DecorativeBlocks.RELIC_BLOCKS) {
            String path = block.getId().getPath();
            map.put((Block)block.get(), new ResourceLocation[]{Confluence.asResource("geo/block/" + path + ".geo.json"), Confluence.asResource("textures/block/" + path + ".png"), Confluence.asResource("animations/block/" + path + ".animation.json")});
        }
    });

    private static ResourceLocation[] getLocations(RelicBlock.BEntity animatable) {
        return CACHE.get(animatable.getBlockState().getBlock());
    }

    public ResourceLocation getModelResource(RelicBlock.BEntity animatable) {
        return RelicBlockModel.getLocations(animatable)[0];
    }

    public ResourceLocation getTextureResource(RelicBlock.BEntity animatable) {
        return RelicBlockModel.getLocations(animatable)[1];
    }

    public ResourceLocation getAnimationResource(RelicBlock.BEntity animatable) {
        return RelicBlockModel.getLocations(animatable)[2];
    }
}

