/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.common.particle.DamageIndicatorOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class DamageIndicatorParticle
extends TextureSheetParticle {
    private final Component text;
    private float factor = 0.0f;
    private float factorOld = 0.0f;
    private int transparency = 17;
    private int transparencyOld = 17;
    private final boolean big;

    public DamageIndicatorParticle(ClientLevel pLevel, double pX, double pY, double pZ, Component text, boolean big) {
        super(pLevel, pX, pY, pZ);
        this.text = text;
        this.lifetime = 30;
        this.big = big;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(@NotNull VertexConsumer pBuffer, Camera camera, float pPartialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 camPos = camera.getPosition();
        double dx = this.x - camPos.x;
        double dy = Mth.lerp((double)pPartialTicks, (double)this.yo, (double)this.y) - camPos.y;
        double dz = this.z - camPos.z;
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        poseStack.translate(dx, dy, dz);
        poseStack.mulPose(camera.rotation());
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        float f = Mth.lerp((float)pPartialTicks, (float)this.factorOld, (float)this.factor);
        poseStack.scale(f, f, f);
        int width = minecraft.font.width((FormattedText)this.text);
        Matrix4f matrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        minecraft.font.renderText(this.text.getVisualOrderText(), (float)(-width) / 2.0f, 0.0f, Mth.lerpInt((float)pPartialTicks, (int)this.transparencyOld, (int)this.transparency) << 24, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, this.getLightColor(pPartialTicks));
        matrix.translate(0.0f, 0.0f, 0.03f);
        minecraft.font.renderText(this.text.getVisualOrderText(), (float)(-width) / 2.0f, 0.0f, Mth.lerpInt((float)pPartialTicks, (int)this.transparencyOld, (int)this.transparency) << 24, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, this.getLightColor(pPartialTicks));
        bufferSource.endBatch();
        poseStack.popPose();
    }

    public void tick() {
        this.transparencyOld = this.transparency;
        this.factorOld = this.factor;
        this.yo = this.y;
        if (this.age <= 4) {
            this.transparency = Math.min(this.transparency + 80, 255);
            this.factor = LibUtils.cubicBezier((float)((float)this.age / 5.0f), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f) * (this.big ? 0.06f : 0.04f);
        }
        float add = LibUtils.cubicBezier((float)((float)this.age / (float)this.lifetime), (float)0.0f, (float)0.8f, (float)1.0f, (float)1.0f) * 0.1f;
        float yOffset = 0.1f - add;
        this.y += (double)yOffset;
        if (this.age >= this.lifetime - 3) {
            this.transparency = Math.max(this.transparency - 60, 0);
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<DamageIndicatorOptions> {
        @Nullable
        public Particle createParticle(@NotNull DamageIndicatorOptions options, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            if (!ClientConfigs.damageIndicator && options.type() == DamageIndicatorOptions.Type.DAMAGE || !ClientConfigs.healIndicator && options.type() == DamageIndicatorOptions.Type.HEAL) {
                return null;
            }
            return new DamageIndicatorParticle(pLevel, pX, pY, pZ, options.text(), options.big());
        }
    }
}

