/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.block.common.MuralBlock;
import org.joml.Matrix4f;

public class MuralBlockRenderer
implements BlockEntityRenderer<MuralBlock.BEntity> {
    public void render(MuralBlock.BEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ClientLevel level = Minecraft.getInstance().level;
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)MuralBlock.FACING);
        int light = level == null ? packedLight : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().relative(direction.getOpposite()));
        blockEntity.getBack().ifPresent(datas -> this.renderData((List<MuralBlock.MuralData>)datas, poseStack, light, 180.0f - direction.toYRot()));
        blockEntity.getLeft().ifPresent(datas -> this.renderData((List<MuralBlock.MuralData>)datas, poseStack, light, 270.0f - direction.toYRot()));
        blockEntity.getRight().ifPresent(datas -> this.renderData((List<MuralBlock.MuralData>)datas, poseStack, light, 90.0f - direction.toYRot()));
        blockEntity.getFront().ifPresent(datas -> this.renderData((List<MuralBlock.MuralData>)datas, poseStack, light, 360.0f - direction.toYRot()));
    }

    private void renderData(List<MuralBlock.MuralData> datas, PoseStack poseStack, int packedLight, float angle) {
        Font font = Minecraft.getInstance().font;
        LightTexture lightTexture = Minecraft.getInstance().gameRenderer.lightTexture();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        poseStack.translate(0.5f, 1.0f, -0.5f);
        for (MuralBlock.MuralData data : datas) {
            poseStack.pushPose();
            poseStack.translate(data.x(), data.y(), data.z());
            poseStack.mulPose(Axis.ZP.rotation((float)Math.PI + data.roll()));
            poseStack.scale(data.scale(), data.scale(), data.scale());
            data.text().ifPresent(text -> {
                FormattedCharSequence visualOrderText = text.component().getVisualOrderText();
                Matrix4f matrix = poseStack.last().pose();
                int color = (text.color() & 0xFC000000) == 0 ? text.color() | 0xFF000000 : text.color();
                MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                if (text.dropShadow()) {
                    font.renderText(visualOrderText, text.x(), text.y(), color, true, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, text.backgroundColor(), packedLight);
                    matrix = matrix.translate(0.0f, 0.0f, -0.03f, new Matrix4f());
                }
                font.renderText(visualOrderText, text.x(), text.y(), color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, text.backgroundColor(), packedLight);
            });
            data.icon().ifPresent(icon -> {
                lightTexture.turnOnLightLayer();
                RenderSystem.enableDepthTest();
                RenderSystem.setShader(GameRenderer::getParticleShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.atlasLocation());
                BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                Matrix4f matrix4f = poseStack.last().pose();
                int x1 = icon.x();
                int x2 = x1 + icon.uWidth();
                int y1 = icon.y();
                int y2 = y1 + icon.vHeight();
                float minU = icon.uOffset() / (float)icon.textureWidth();
                float maxU = (icon.uOffset() + (float)icon.uWidth()) / (float)icon.textureWidth();
                float minV = icon.vOffset() / (float)icon.textureHeight();
                float maxV = (icon.vOffset() + (float)icon.vHeight()) / (float)icon.textureHeight();
                builder.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setUv(minU, minV).setColor(-1).setLight(packedLight);
                builder.addVertex(matrix4f, (float)x1, (float)y2, 0.0f).setUv(minU, maxV).setColor(-1).setLight(packedLight);
                builder.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setUv(maxU, maxV).setColor(-1).setLight(packedLight);
                builder.addVertex(matrix4f, (float)x2, (float)y1, 0.0f).setUv(maxU, minV).setColor(-1).setLight(packedLight);
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                RenderSystem.disableDepthTest();
                lightTexture.turnOffLightLayer();
            });
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

