/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.lib.util.RenderUtils;
import org.confluence.mod.common.block.functional.BaseSoulInABottleBlock;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;

public class SoulBottleBlockRenderer
implements BlockEntityRenderer<BaseSoulInABottleBlock.BEntity> {
    private final RandomSource RANDOM = RandomSource.create();
    private double ROTATE00 = this.RANDOM.nextDouble() * (Math.PI * 2);
    private double ROTATE01 = this.RANDOM.nextDouble() * (Math.PI * 2);
    private double ROTATE10 = this.RANDOM.nextDouble() * (Math.PI * 2);
    private double ROTATE11 = this.RANDOM.nextDouble() * (Math.PI * 2);
    private double ROTATE1OFFSET = this.RANDOM.nextDouble() * 0.05 + 0.075;
    private double[] SIZE = new double[]{this.RANDOM.nextDouble(), this.RANDOM.nextDouble()};
    private double[] SIZE_OFFSET = new double[]{this.RANDOM.nextDouble() * 0.05 + 0.075, this.RANDOM.nextDouble() * 0.05 + 0.075};
    private boolean[] SIZE_UP = new boolean[]{true, true};
    private long TIME_BEFORE = 0L;
    private static final Map<Block, Vector3i> SOUL_COLORS = Map.of((Block)FunctionalBlocks.SOUL_OF_FLIGHT_IN_A_BOTTLE.get(), new Vector3i(1026003, 13368060, 9169903), (Block)FunctionalBlocks.SOUL_OF_LIGHT_IN_A_BOTTLE.get(), new Vector3i(16747987, 0xFFFFEB, 16766191), (Block)FunctionalBlocks.SOUL_OF_FRIGHT_IN_A_BOTTLE.get(), new Vector3i(16737849, 16770262, 16757629), (Block)FunctionalBlocks.SOUL_OF_NIGHT_IN_A_BOTTLE.get(), new Vector3i(10641386, 0xFDD4FF, 14716415), (Block)FunctionalBlocks.SOUL_OF_MIGHT_IN_A_BOTTLE.get(), new Vector3i(4959231, 0xFFFFEB, 11853567), (Block)FunctionalBlocks.SOUL_OF_SIGHT_IN_A_BOTTLE.get(), new Vector3i(2543995, 0xFFFFEB, 0xC7FFCC), (Block)FunctionalBlocks.SOUL_OF_BRIGHT_IN_A_BOTTLE.get(), new Vector3i(16763465, 0xFDFFDB, 16774548), (Block)FunctionalBlocks.SOUL_OF_VOIGHT_IN_A_BOTTLE.get(), new Vector3i(1966132, 14924799, 10427391));

    public void render(BaseSoulInABottleBlock.BEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        long timeVariable = System.currentTimeMillis() / 20L % 10000L;
        boolean updata = this.TIME_BEFORE != timeVariable;
        this.TIME_BEFORE = timeVariable;
        if (updata) {
            this.ROTATE00 += 0.1;
            this.ROTATE01 += 0.1;
            this.ROTATE10 += 0.07;
            this.ROTATE11 += 0.07;
        }
        BlockPos blockPos = blockEntity.getBlockPos();
        Vector3d offsetPos = new Vector3d(0.5, blockEntity.getBlockState() == blockEntity.getBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)) ? 0.425 : 0.3, 0.5);
        Vector3d entityMainPos = new Vector3d((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        Vector3i colors = SOUL_COLORS.getOrDefault(blockEntity.getBlockState().getBlock(), new Vector3i(1026003, 13368060, 9169903));
        int color0 = colors.x;
        int r0 = color0 >> 16 & 0xFF;
        int g0 = color0 >> 8 & 0xFF;
        int b0 = color0 & 0xFF;
        int color1 = colors.y;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int color2 = colors.z;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        for (int i = 0; i < 2; ++i) {
            double sizeGet = this.SIZE[i];
            double sizeOffset = this.SIZE_OFFSET[i];
            boolean sizeUp = this.SIZE_UP[i];
            if ((sizeGet += sizeUp ? sizeOffset : -sizeOffset) > 1.0) {
                sizeGet = 1.0;
                sizeUp = false;
            } else if (sizeGet < 0.0) {
                sizeGet = 0.0;
                sizeUp = true;
            }
            if (updata) {
                this.SIZE[i] = sizeGet;
                this.SIZE_UP[i] = sizeUp;
            }
            this.RANDOM.setSeed((long)blockPos.getX());
            this.RANDOM.setSeed((long)(blockPos.getY() + this.RANDOM.nextInt(100)));
            this.RANDOM.setSeed((long)(blockPos.getZ() + this.RANDOM.nextInt(100)));
            int step = this.RANDOM.nextInt(20);
            for (int j = 0; j < step; ++j) {
                if ((sizeGet += sizeUp ? sizeOffset : -sizeOffset) > 1.0) {
                    sizeGet = 1.0;
                    sizeUp = false;
                    continue;
                }
                if (!(sizeGet < 0.0)) continue;
                sizeGet = 0.0;
                sizeUp = true;
            }
            double pi = 1 - 2 * i;
            double radius = 0.125;
            double cubeSize = 0.125;
            Vector3d offset = new Vector3d(Math.cos(this.ROTATE10 + this.RANDOM.nextDouble() * 10.0) * Math.cos(this.ROTATE11 + this.RANDOM.nextDouble() * 10.0) * radius * pi, Math.sin(this.ROTATE10 + this.RANDOM.nextDouble() * 10.0) * radius * pi, -Math.cos(this.ROTATE10 + this.RANDOM.nextDouble() * 10.0) * Math.sin(this.ROTATE11 + this.RANDOM.nextDouble() * 10.0) * radius * pi).add((Vector3dc)offsetPos);
            double rotate0 = this.RANDOM.nextDouble() * 10.0;
            double rotate1 = this.RANDOM.nextDouble() * 10.0;
            RenderUtils.drawCube((PoseStack)poseStack, (MultiBufferSource)bufferSource, (double)(sizeGet * cubeSize), (int)r0, (int)g0, (int)b0, (int)255, (Vector3d)entityMainPos, (Vector3d)offset, (boolean)true, (double)(this.ROTATE00 * pi * this.ROTATE1OFFSET + rotate0), (double)(this.ROTATE01 * pi * this.ROTATE1OFFSET + rotate1));
            RenderUtils.drawCube((PoseStack)poseStack, (MultiBufferSource)bufferSource, (double)(sizeGet * cubeSize + 0.015625), (int)r1, (int)g1, (int)b1, (int)255, (Vector3d)entityMainPos, (Vector3d)offset, (boolean)false, (double)(this.ROTATE00 * pi * this.ROTATE1OFFSET + rotate0), (double)(this.ROTATE01 * pi * this.ROTATE1OFFSET + rotate1));
            RenderUtils.drawCube((PoseStack)poseStack, (MultiBufferSource)bufferSource, (double)(sizeGet * cubeSize + 0.078125), (int)r2, (int)g2, (int)b2, (int)255, (Vector3d)entityMainPos, (Vector3d)offset, (boolean)false, (double)(this.ROTATE00 * pi * this.ROTATE1OFFSET + rotate0), (double)(this.ROTATE01 * pi * this.ROTATE1OFFSET + rotate1));
        }
    }
}

