/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.RenderUtils;
import org.confluence.mod.common.block.functional.TuffBoothBlock;
import org.joml.Vector3d;

public class TuffBoothBlockRenderer
implements BlockEntityRenderer<TuffBoothBlock.TuffBoothBlockEntity> {
    public static void renderLineBox(PoseStack poseStack, VertexConsumer consumer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha, float red2, float green2, float blue2, boolean withoutUp) {
        PoseStack.Pose posestack$pose = poseStack.last();
        float f = (float)minX;
        float f1 = (float)minY;
        float f2 = (float)minZ;
        float f3 = (float)maxX;
        float f4 = (float)maxY;
        float f5 = (float)maxZ;
        if (withoutUp) {
            consumer.addVertex(posestack$pose, f, f1, f2).setColor(red, green2, blue2, alpha).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f3, f1, f2).setColor(red, green2, blue2, alpha).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f, f1, f2).setColor(red2, green2, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
            consumer.addVertex(posestack$pose, f, f1, f5).setColor(red2, green2, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
            consumer.addVertex(posestack$pose, f3, f1, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, -1.0f);
            consumer.addVertex(posestack$pose, f3, f1, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, -1.0f);
            consumer.addVertex(posestack$pose, f, f1, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f3, f1, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        }
        if (!withoutUp) {
            consumer.addVertex(posestack$pose, f3, f4, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f, f4, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f, f4, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
            consumer.addVertex(posestack$pose, f, f4, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
            consumer.addVertex(posestack$pose, f, f4, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f3, f4, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
            consumer.addVertex(posestack$pose, f3, f4, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
            consumer.addVertex(posestack$pose, f3, f4, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
        }
        consumer.addVertex(posestack$pose, f3, f1, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f4, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f1, f5).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f1, f2).setColor(red2, green, blue2, alpha).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f4, f2).setColor(red2, green, blue2, alpha).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f1, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f2).setColor(red, green, blue, alpha).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
    }

    public void render(TuffBoothBlock.TuffBoothBlockEntity boothEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockHitResult blockHitResult;
        BlockPos lookedAtPos;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        int posX = boothEntity.getBlockPos().getX();
        int posY = boothEntity.getBlockPos().getY();
        int posZ = boothEntity.getBlockPos().getZ();
        boolean showUI = !minecraft.options.hideGui;
        Vec3 exactHitLocation = null;
        if (minecraft.hitResult != null && minecraft.hitResult.getType() == HitResult.Type.BLOCK && (lookedAtPos = (blockHitResult = (BlockHitResult)minecraft.hitResult).getBlockPos()).equals((Object)boothEntity.getBlockPos())) {
            exactHitLocation = blockHitResult.getLocation().add(new Vec3((double)(-posX), (double)(-posY), (double)(-posZ)));
        }
        float a = 0.6901961f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        if (showUI && exactHitLocation != null && !player.isSpectator()) {
            if (exactHitLocation.y > 0.5) {
                poseStack.pushPose();
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)0.1865, (double)0.499, (double)0.1865, (double)0.8135, (double)0.8135, (double)0.8135, (float)r, (float)g, (float)b, (float)a);
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)-0.001, (double)0.8115, (double)-0.001, (double)1.001, (double)1.001, (double)1.001, (float)r, (float)g, (float)b, (float)a);
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.mulPose(Axis.YP.rotation(0.7853982f));
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)-0.5635, (double)0.5615, (double)-0.126, (double)0.5635, (double)0.8135, (double)0.126, (float)r, (float)g, (float)b, (float)a);
                poseStack.mulPose(Axis.YP.rotation(1.5707964f));
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)-0.5635, (double)0.5615, (double)-0.126, (double)0.5635, (double)0.8135, (double)0.126, (float)r, (float)g, (float)b, (float)a);
                poseStack.popPose();
            } else {
                poseStack.pushPose();
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)0.1865, (double)0.1885, (double)0.1865, (double)0.8135, (double)0.501, (double)0.8135, (float)r, (float)g, (float)b, (float)a);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.0615, -0.001, 0.0615, 0.9385, 0.1885, 0.9385, r, g, b, a, r, g, b, true);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.0615, 0.1885, 0.0615, 0.251, 0.3135, 0.251, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.0615, 0.1885, 0.749, 0.251, 0.3135, 0.9385, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.749, 0.1885, 0.0615, 0.9385, 0.3135, 0.251, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.749, 0.1885, 0.749, 0.9385, 0.3135, 0.9385, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.0615, 0.1885, 0.249, 0.9385, 0.1885, 0.751, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.249, 0.1885, 0.0615, 0.751, 0.1885, 0.9385, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.749, 0.1885, 0.749, 0.8135, 0.3135, 0.8135, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.749, 0.1885, 0.1865, 0.8135, 0.3135, 0.251, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.1865, 0.1885, 0.749, 0.251, 0.3135, 0.8135, r, g, b, a, r, g, b, false);
                TuffBoothBlockRenderer.renderLineBox(poseStack, buffer, 0.1865, 0.1885, 0.1865, 0.251, 0.3135, 0.251, r, g, b, a, r, g, b, false);
                poseStack.popPose();
            }
            if (player.getAbilities().mayBuild) {
                poseStack.pushPose();
                poseStack.translate(0.5, 0.0, 0.5);
                poseStack.mulPose(Axis.YP.rotation(0.7853982f));
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)-0.5625, (double)0.5625, (double)-0.125, (double)0.5625, (double)0.8125, (double)0.125, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                poseStack.mulPose(Axis.YP.rotation(1.5707964f));
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)-0.5625, (double)0.5625, (double)-0.125, (double)0.5625, (double)0.8125, (double)0.125, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                poseStack.popPose();
            }
        }
        float scale = 1.0f;
        ItemStack itemStack = boothEntity.getItemHandler().getStackInSlot(0);
        if (itemStack.isEmpty() && exactHitLocation == null) {
            return;
        }
        poseStack.pushPose();
        long gameTime = 0L;
        if (minecraft.level != null) {
            gameTime = minecraft.level.getGameTime();
        }
        double timeWithPartialTick = (float)gameTime + partialTick;
        double angleInRadians = timeWithPartialTick / 60.0 * (Math.PI * 2);
        float yOffset = (float)(Math.sin(angleInRadians) * 0.08);
        float cubeAlpha = (float)Math.sin(angleInRadians * 1.5);
        poseStack.translate(0.5f, 1.25f + yOffset, 0.5f);
        float rotationAngle = (float)(timeWithPartialTick % 360.0 / 60.0 * 6.2831854820251465);
        poseStack.mulPose(Axis.YP.rotation(rotationAngle));
        poseStack.scale(scale, scale, scale);
        if (!player.getMainHandItem().isEmpty() && exactHitLocation != null && exactHitLocation.y > 0.5) {
            RenderUtils.drawCube((PoseStack)poseStack, (MultiBufferSource)bufferSource, (double)0.52, (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)), (int)((int)((cubeAlpha + 1.0f) / 8.0f * 255.0f)), (Vector3d)new Vector3d((double)posX, (double)posY, (double)posZ), (Vector3d)new Vector3d(0.0, 0.125, 0.0), (boolean)true, (double)0.7853981633974483, (double)0.0);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)-0.26, (double)-0.135, (double)-0.26, (double)0.26, (double)0.385, (double)0.26, (float)r, (float)g, (float)b, (float)((cubeAlpha + 1.0f) / 4.0f));
        }
        boolean pop = true;
        if (!itemStack.isEmpty()) {
            minecraft.getItemRenderer().render(itemStack, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight, packedOverlay, minecraft.getItemRenderer().getModel(itemStack, null, null, 0));
            poseStack.popPose();
            pop = false;
            if (((Boolean)boothEntity.getBlockState().getValue((Property)TuffBoothBlock.SHOW_NAME)).booleanValue()) {
                int textColor;
                poseStack.pushPose();
                poseStack.translate(0.5, 1.83 + (double)yOffset, 0.5);
                poseStack.mulPose(minecraft.getEntityRenderDispatcher().cameraOrientation());
                float scale1 = 0.02f;
                poseStack.scale(scale1, -scale1, scale1);
                Font font = minecraft.font;
                Component text = itemStack.getDisplayName();
                String plainText = text.getString();
                String cleanText = plainText.replaceAll("^\\[|]$", "");
                MutableComponent cleanComponent = Component.literal((String)cleanText).withStyle(text.getStyle().withColor((TextColor)null));
                MutableComponent component = Component.literal((String)cleanText).withStyle(text.getStyle());
                ModRarity rarity = ModRarity.getRarity((ItemStack)itemStack);
                boolean useTextColor = true;
                if (rarity != null) {
                    textColor = rarity.color();
                } else {
                    textColor = 0xFFFFFF;
                    useTextColor = false;
                }
                int textWidth = font.width((FormattedText)cleanComponent);
                float xOffset = (float)(-textWidth) / 2.0f;
                float alpha = 0.2509804f;
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                PoseStack.Pose pose = poseStack.last();
                VertexConsumer consumer = bufferSource.getBuffer(RenderType.debugQuads());
                consumer.addVertex(pose, -xOffset + 1.0f, -1.0f, -0.1f).setColor(red, green, blue, alpha);
                consumer.addVertex(pose, xOffset - 1.0f, -1.0f, -0.1f).setColor(red, green, blue, alpha);
                consumer.addVertex(pose, xOffset - 1.0f, 9.0f, -0.1f).setColor(red, green, blue, alpha);
                consumer.addVertex(pose, -xOffset + 1.0f, 9.0f, -0.1f).setColor(red, green, blue, alpha);
                font.drawInBatch((Component)(useTextColor ? cleanComponent : component), xOffset, 0.0f, textColor, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 255);
                poseStack.popPose();
            }
        }
        if (pop) {
            poseStack.popPose();
        }
    }
}

