/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.confluence.mod.common.entity.DeadBodyPartEntity;
import org.confluence.mod.mixin.client.accessor.AgeableListModelAccessor;
import org.confluence.mod.mixin.client.accessor.LivingEntityRendererAccessor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.Color;

public class BodyPartRenderer
extends EntityRenderer<DeadBodyPartEntity> {
    public BodyPartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(DeadBodyPartEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    /*
     * Unable to fully structure code
     */
    public void render(DeadBodyPartEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        block27: {
            block28: {
                block26: {
                    dying = entity.dyingEntity;
                    if (dying == null) {
                        return;
                    }
                    cube = entity.cube;
                    minecraft = Minecraft.getInstance();
                    renderer = minecraft.getEntityRenderDispatcher().getRenderer(dying);
                    if (!(renderer instanceof GeoEntityRenderer)) break block26;
                    geoRenderer = (GeoEntityRenderer)renderer;
                    if (!(dying instanceof GeoAnimatable)) break block26;
                    animatable = (GeoAnimatable)dying;
                    if (cube instanceof GeoCube) {
                        geoCube = (GeoCube)cube;
                        twoQuads = new GeoQuad[2];
                        for (GeoQuad quad : geoCube.quads()) {
                            if (quad == null) continue;
                            if (twoQuads[0] == null) {
                                twoQuads[0] = quad;
                                continue;
                            }
                            twoQuads[1] = quad;
                            break;
                        }
                        if (twoQuads[0] == null) {
                            return;
                        }
                        if (twoQuads[1] == null) {
                            twoQuads[1] = twoQuads[0];
                        }
                        minY = 3.4028235E38f;
                        maxY = -3.4028235E38f;
                        for (GeoVertex vertex : twoQuads[0].vertices()) {
                            minY = Math.min(minY, vertex.position().y);
                            maxY = Math.max(maxY, vertex.position().y);
                        }
                        centerY = (minY + maxY) / 2.0f;
                        poseStack.pushPose();
                        bakedGeoModel = geoRenderer.getGeoModel().getBakedModel(geoRenderer.getGeoModel().getModelResource(animatable, (GeoRenderer)geoRenderer));
                        geoRenderer.preRender(poseStack, dying, bakedGeoModel, null, null, false, 1.0f, 0, 0, 0);
                        poseStack.mulPose(Axis.YP.rotationDegrees(-dying.getYRot() + 180.0f));
                        poseStack.mulPose(Axis.XP.rotationDegrees(dying.getXRot()));
                        poseStack.translate(0.0f, 0.01f, 0.0f);
                        rots = entity.boneRots;
                        pivots = entity.bonePivots;
                        for (i = rots.size() - 1; i >= 0; --i) {
                            boneRot = rots.get(i);
                            bonePivot = pivots.get(i);
                            poseStack.translate(bonePivot.x, bonePivot.y, bonePivot.z);
                            poseStack.mulPose(Axis.ZP.rotation(boneRot.z));
                            poseStack.mulPose(Axis.YP.rotation(boneRot.y));
                            poseStack.mulPose(Axis.XP.rotation(boneRot.x));
                            poseStack.translate(-bonePivot.x, -bonePivot.y, -bonePivot.z);
                        }
                        poseStack.translate(0.0f, centerY, 0.0f);
                        this.applyRandomRotation(entity, poseStack, partialTick);
                        poseStack.translate(0.0f, -centerY, 0.0f);
                        textureLocation = geoRenderer.getTextureLocation(dying);
                        renderType = geoRenderer.getRenderType(dying, textureLocation, bufferSource, partialTick);
                        geoRenderer.renderCube(poseStack, geoCube, bufferSource.getBuffer(renderType == null ? RenderType.entityCutoutNoCull((ResourceLocation)textureLocation) : renderType), packedLight, OverlayTexture.pack((int)OverlayTexture.u((float)0.0f), (int)OverlayTexture.v((boolean)false)), geoRenderer.getRenderColor(dying, partialTick, packedLight).argbInt());
                        poseStack.popPose();
                    } else if (cube instanceof GeoBone) {
                        geoBone = (GeoBone)cube;
                        bakedGeoModel = geoRenderer.getGeoModel().getBakedModel(geoRenderer.getGeoModel().getModelResource(animatable, (GeoRenderer)geoRenderer));
                        geoRenderer.preRender(poseStack, dying, bakedGeoModel, null, null, false, 1.0f, 0, 0, 0);
                        this.applyRandomRotation(entity, poseStack, partialTick);
                        textureLocation = geoRenderer.getTextureLocation(dying);
                        renderType = geoRenderer.getRenderType(dying, textureLocation, bufferSource, partialTick);
                        geoRenderer.renderRecursively(poseStack, dying, geoBone, renderType, bufferSource, bufferSource.getBuffer(renderType == null ? RenderType.entityCutoutNoCull((ResourceLocation)textureLocation) : renderType), false, partialTick, packedLight, OverlayTexture.pack((int)OverlayTexture.u((float)0.0f), (int)OverlayTexture.v((boolean)false)), geoRenderer.getRenderColor(dying, partialTick, packedLight).argbInt());
                    }
                    break block27;
                }
                if (!(renderer instanceof LivingEntityRenderer)) break block27;
                livingRenderer = (LivingEntityRenderer)renderer;
                if (!(dying instanceof LivingEntity)) break block27;
                living = (LivingEntity)dying;
                if (!(cube instanceof ModelPart.Cube)) break block28;
                partCube = (ModelPart.Cube)cube;
                if (minecraft.player == null) break block28;
                ra = (LivingEntityRendererAccessor)livingRenderer;
                visible = ra.callIsBodyVisible(living);
                translucent = visible == false && entity.isInvisibleTo((Player)minecraft.player) == false;
                glowing = minecraft.shouldEntityAppearGlowing((Entity)entity);
                v0 = renderType = entity.texture == null ? ra.callGetRenderType(living, visible, translucent, glowing) : RenderType.armorCutoutNoCull((ResourceLocation)entity.texture);
                if (renderType == null) {
                    return;
                }
                poseStack.pushPose();
                halfMinSide = entity.minSide / 2.0f;
                poseStack.translate(0.0f, halfMinSide, 0.0f);
                this.applyRandomRotation(entity, poseStack, partialTick);
                poseStack.translate(-entity.xOffset, -entity.yOffset - halfMinSide, -entity.zOffset);
                var27_55 = livingRenderer.getModel();
                if (!(var27_55 instanceof AgeableHierarchicalModel)) ** GOTO lbl-1000
                model = (AgeableHierarchicalModel)var27_55;
                if (model.young) {
                    poseStack.scale(model.youngScaleFactor, model.youngScaleFactor, model.youngScaleFactor);
                } else if (livingRenderer.getModel().young && (var27_55 = livingRenderer.getModel()) instanceof AgeableListModelAccessor) {
                    model = (AgeableListModelAccessor)var27_55;
                    for (ModelPart bodyPart : model.callBodyParts()) {
                        if (entity.modelPart != bodyPart) continue;
                        scale = 1.0f / model.getBabyBodyScale();
                        poseStack.scale(scale, scale, scale);
                        break;
                    }
                    for (ModelPart headPart : model.callHeadParts()) {
                        if (entity.modelPart != headPart) continue;
                        if (!model.getScaleHead()) break;
                        scale = 1.5f / model.getBabyHeadScale();
                        poseStack.scale(scale, scale, scale);
                        break;
                    }
                }
                scale = living.getScale();
                poseStack.scale(scale, scale, scale);
                ra.callSetupRotations(living, poseStack, 0.0f, living.yBodyRot, 1.0f, scale);
                modelPartRot = entity.modelPartRot;
                poseStack.mulPose(Axis.ZP.rotation(modelPartRot.z));
                poseStack.mulPose(Axis.YP.rotation(-modelPartRot.y));
                poseStack.mulPose(Axis.XP.rotation(-modelPartRot.x));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                ra.callScale(living, poseStack, 1.0f);
                partCube.compile(poseStack.last(), bufferSource.getBuffer(renderType), packedLight, 655360, translucent != false ? 0x26FFFFFF : -1);
                poseStack.popPose();
                break block27;
            }
            if (cube instanceof ItemStack && (ra = (itemStack = (ItemStack)cube).getItem()) instanceof Equipable) {
                equipable = (Equipable)ra;
                ra = livingRenderer.getModel();
                if (ra instanceof HumanoidModel) {
                    baseModel = (HumanoidModel)ra;
                    humanoidModel = GeoRenderProvider.of((Item)itemStack.getItem()).getGeoArmorRenderer(living, itemStack, null, baseModel);
                    if (!(humanoidModel instanceof GeoArmorRenderer)) {
                        return;
                    }
                    geoArmorRenderer = (GeoArmorRenderer)humanoidModel;
                    baseModel.setupAnim(living, 0.0f, 0.0f, 0.0f, living.getYHeadRot(), living.getXRot());
                    poseStack.pushPose();
                    equipmentSlot = equipable.getEquipmentSlot();
                    this.applyRandomRotation(entity, poseStack, partialTick);
                    baby = living.isBaby();
                    if (equipmentSlot == EquipmentSlot.CHEST) {
                        poseStack.translate(0.0, baby != false ? 1.1 : 0.5, baby != false ? -0.1 : -0.2);
                    } else if (equipmentSlot == EquipmentSlot.LEGS) {
                        poseStack.translate(0.0, baby != false ? 1.4 : 1.25, 0.0);
                    } else if (equipmentSlot == EquipmentSlot.FEET) {
                        poseStack.translate(0.0, 1.5, 0.0);
                    } else if (equipmentSlot == EquipmentSlot.HEAD) {
                        poseStack.translate(0.0, baby != false ? 0.8 : -0.25, 0.0);
                    }
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(-dying.getYRot() + 180.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(dying.getXRot()));
                    geoArmorRenderer.prepForRender(dying, itemStack, equipable.getEquipmentSlot(), baseModel, bufferSource, partialTick, 0.0f, 0.0f, living.getYHeadRot(), living.getXRot());
                    geoArmorRenderer.renderToBuffer(poseStack, null, packedLight, OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
                    poseStack.popPose();
                    geoArmorRenderer.doPostRenderCleanup();
                }
            }
        }
    }

    private void applyRandomRotation(DeadBodyPartEntity entity, PoseStack poseStack, float partialTick) {
        if (entity.still) {
            return;
        }
        if (entity.stop) {
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)((entity.animTick + 1) * 10) * entity.rotZ));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)((entity.animTick + 1) * 10) * entity.rotY));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)((entity.animTick + 1) * 10) * entity.rotX));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)((float)(entity.animTick * 10) * entity.rotZ), (float)((float)((entity.animTick + 1) * 10) * entity.rotZ))));
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)((float)(entity.animTick * 10) * entity.rotY), (float)((float)((entity.animTick + 1) * 10) * entity.rotY))));
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTick, (float)((float)(entity.animTick * 10) * entity.rotX), (float)((float)((entity.animTick + 1) * 10) * entity.rotX))));
        }
    }
}

