/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.hook;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.client.model.entity.hook.BaseHookModel;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;

public abstract class AbstractHookRenderer<T extends AbstractHookEntity>
extends EntityRenderer<T> {
    protected final EntityModel<? extends AbstractHookEntity> model;
    protected final BlockRenderDispatcher dispatcher;

    public AbstractHookRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new BaseHookModel(pContext.bakeLayer(BaseHookModel.LAYER_LOCATION));
        this.dispatcher = pContext.getBlockRenderDispatcher();
    }

    public AbstractHookRenderer(EntityRendererProvider.Context pContext, EntityModel<? extends AbstractHookEntity> model) {
        super(pContext);
        this.model = model;
        this.dispatcher = pContext.getBlockRenderDispatcher();
    }

    public abstract BlockState getChain(T var1);

    public boolean shouldRender(T entity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (super.shouldRender(entity, pCamera, pCamX, pCamY, pCamZ)) {
            return true;
        }
        Entity owner = entity.getOwner();
        if (owner != null) {
            Vec3 vec3 = owner.position().add(0.0, (double)owner.getBbHeight() * 0.65, 0.0);
            Vec3 vec31 = entity.position().add(0.0, 0.25, 0.0);
            return pCamera.isVisible(new AABB(vec31.x, vec31.y, vec31.z, vec3.x, vec3.y, vec3.z));
        }
        return false;
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        int skyLight = LightTexture.pack((int)10, (int)LightTexture.sky((int)packedLight));
        this.renderHook(entity, poseStack, multiBufferSource, skyLight);
        Entity owner = entity.getOwner();
        if (owner != null) {
            poseStack.pushPose();
            Vec3 vec3 = AbstractHookRenderer.getPosition(owner, (double)owner.getBbHeight() * 0.65, partialTick);
            Vec3 vec31 = AbstractHookRenderer.getPosition(entity, 0.25, partialTick);
            Vec3 vec32 = vec3.subtract(vec31).normalize();
            poseStack.mulPose(Axis.YP.rotation(1.5707964f - (float)Math.atan2(vec32.z, vec32.x)));
            poseStack.mulPose(Axis.XP.rotation((float)Math.acos(vec32.y)));
            poseStack.translate(-0.5, 0.0, -0.75);
            float distance = entity.distanceTo(owner);
            int floor = (int)distance;
            BlockState chain = this.getChain(entity);
            for (int i = 0; i < floor; ++i) {
                this.dispatcher.renderSingleBlock(chain, poseStack, multiBufferSource, skyLight, OverlayTexture.NO_OVERLAY);
                poseStack.translate(0.0, 1.0, 0.0);
            }
            float delta = distance - (float)floor;
            if (((AbstractHookEntity)((Object)entity)).lastDelta - delta > 0.5f || (double)((AbstractHookEntity)((Object)entity)).lastDelta == 0.0) {
                ((AbstractHookEntity)((Object)entity)).lastDelta = delta;
            }
            delta = Mth.lerp((float)partialTick, (float)((AbstractHookEntity)((Object)entity)).lastDelta, (float)delta);
            poseStack.scale(1.0f, delta, 1.0f);
            ((AbstractHookEntity)((Object)entity)).lastDelta = delta;
            this.dispatcher.renderSingleBlock(chain, poseStack, multiBufferSource, skyLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }

    protected void renderHook(T entity, PoseStack poseStack, MultiBufferSource multiBufferSource, int skyLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.getYRot() - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(entity.getXRot()));
        this.model.renderToBuffer(poseStack, multiBufferSource.getBuffer(this.model.renderType(this.getTextureLocation((Entity)entity))), skyLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public static Vec3 getPosition(Entity entity, double pYOffset, float pPartialTick) {
        double x = Mth.lerp((double)pPartialTick, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)pPartialTick, (double)entity.yOld, (double)entity.getY()) + pYOffset;
        double z = Mth.lerp((double)pPartialTick, (double)entity.zOld, (double)entity.getZ());
        return new Vec3(x, y, z);
    }
}

