/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile.sword;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.sword.NightEdgeProjectile;
import org.jetbrains.annotations.NotNull;

public class NightEdgeProjectileRenderer
extends EntityRenderer<NightEdgeProjectile> {
    public NightEdgeProjectileRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(NightEdgeProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.getOwner() == null || entity.tickCount <= 1) {
            return;
        }
        double lerpX = Mth.lerp((double)partialTick, (double)(entity.xo - entity.getOwner().xo), (double)(entity.getX() - entity.getOwner().getX()));
        double lerpY = Mth.lerp((double)partialTick, (double)(entity.yo - entity.getOwner().yo), (double)(entity.getY() - entity.getOwner().getY()));
        double lerpZ = Mth.lerp((double)partialTick, (double)(entity.zo - entity.getOwner().zo), (double)(entity.getZ() - entity.getOwner().getZ()));
        float y = -Mth.lerp((float)partialTick, (float)entity.getOwner().yRotO, (float)entity.getOwner().getYRot()) + 70.0f;
        Vec3 entityPos = new Vec3(lerpX, lerpY, lerpZ);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(y));
        poseStack.mulPose(Axis.XP.rotationDegrees(-15.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-y));
        entity.trail.renderTrail(entity, entityPos, poseStack, bufferSource, packedLight);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(-entityPos.x, -entityPos.y, -entityPos.z);
        poseStack.mulPose(Axis.YP.rotationDegrees(y));
        poseStack.scale(1.0f, 1.0f, -1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-y));
        poseStack.translate(entityPos.x, entityPos.y, entityPos.z);
        poseStack.translate(0.0, 0.1, 0.0);
        poseStack.scale(0.8f, 0.8f, 0.8f);
        poseStack.mulPose(Axis.YP.rotationDegrees(y + 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-y - 180.0f));
        entity.trail.renderTrail(entity, entityPos, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(@NotNull NightEdgeProjectile trailSwordProj) {
        return null;
    }
}

