/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.item.BowItems;
import org.confluence.mod.common.item.bow.ShortBowItem;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public final class ArrowInBowRenderer {
    private static final Map<Item, Vec3> offsets = new HashMap<Item, Vec3>();

    public static void initAdaptionMap() {
        offsets.put((Item)BowItems.DAEDALUS_STORM_BOW.get(), new Vec3((double)0.365f, (double)0.2f, 0.0));
        offsets.put((Item)BowItems.PLATINUM_SHORT_BOW.get(), new Vec3((double)0.08f, 0.0, 0.0));
    }

    private static float getOffset(float charge, @Nullable Vec3 off, Item item) {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        if (item instanceof ShortBowItem) {
            return off == null ? a : (float)off.x + a;
        }
        float offset = off == null ? (charge < 0.65f ? 0.23f + a : (charge < 0.9f ? 0.62f + b : 1.0f + c)) : (float)(charge < 0.65f ? (double)0.23f + off.x + (double)a : (charge < 0.9f ? (double)0.62f + off.y + (double)b : 1.0 + off.z + (double)c));
        return offset;
    }

    public static void bowTransform(ItemStack bow, PoseStack poseStack, float charge, ItemDisplayContext displayContext) {
        if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            Item item = bow.getItem();
            Vec3 off = offsets.get(item);
            float offset = ArrowInBowRenderer.getOffset(charge, off, item);
            poseStack.translate(0.0, 0.2, 0.0);
            if (item instanceof ShortBowItem) {
                poseStack.translate(0.0f, 0.0f, offset);
            } else {
                poseStack.translate(0.0, (double)(-offset) * 0.04, (double)offset * 0.13);
            }
            if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            } else {
                poseStack.translate(0.0, -0.12, -0.25);
            }
            poseStack.scale(1.01f, 1.01f, 1.01f);
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            poseStack.mulPose(Axis.YN.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(20.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(10.0f));
            poseStack.translate(0.1, -0.25, -0.15);
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            poseStack.mulPose(Axis.YN.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(20.0f));
            poseStack.translate(0.1, -0.3, 0.0);
        }
    }

    public static void repeaterTransform(ItemStack arrowItem, ItemStack repeater, PoseStack poseStack, ItemDisplayContext displayContext) {
        if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            if (arrowItem.getItem() instanceof FireworkRocketItem) {
                poseStack.translate(-0.12, 0.278, 0.15);
                poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.XN.rotationDegrees(55.0f));
                return;
            }
            poseStack.translate(0.055, 0.278, 0.15);
            poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(100.0f));
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            if (arrowItem.getItem() instanceof FireworkRocketItem) {
                poseStack.translate(0.12, 0.09, -0.11);
                Quaternionf quaternion = Axis.YN.rotationDegrees(-165.0f);
                quaternion.rotateX(1.5707964f);
                poseStack.mulPose(quaternion);
                return;
            }
            poseStack.translate(-0.042, 0.09, -0.11);
            Quaternionf quaternion = Axis.YN.rotationDegrees(-119.0f);
            quaternion.rotateX(1.5707964f);
            poseStack.mulPose(quaternion);
        }
    }
}

