/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.item.ToolItems;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.util.RenderUtil;

public class DungeonCompassRenderer {
    private static DungeonCompassRenderer INSTANCE;
    private final GeoBone bone;
    private final GeoBone outline;
    private final RenderType boneRenderType;
    private final RenderType outlineRenderType;

    private DungeonCompassRenderer() {
        BakedGeoModel geoModel = (BakedGeoModel)GeckoLibCache.getBakedModels().get(Confluence.asResource("geo/item/dungeon_compass.geo.json"));
        this.bone = (GeoBone)geoModel.getBone("bone").orElseThrow();
        this.bone.updateScale(0.8f, 0.8f, 0.8f);
        this.outline = (GeoBone)geoModel.getBone("outline").orElseThrow();
        this.outline.updateScale(0.8f, 0.8f, 0.8f);
        ResourceLocation texture = Confluence.asResource("textures/item/dungeon_compass.png");
        this.boneRenderType = RenderType.text((ResourceLocation)texture);
        this.outlineRenderType = RenderType.eyes((ResourceLocation)texture);
    }

    public static DungeonCompassRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DungeonCompassRenderer();
        }
        return INSTANCE;
    }

    public static void renderInWorld(PoseStack poseStack, LocalPlayer player, Minecraft minecraft) {
        ItemStack headItem = (ItemStack)player.getInventory().armor.get(3);
        if (headItem.isEmpty() || !headItem.is(ToolItems.DUNGEON_COMPASS)) {
            return;
        }
        CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)headItem);
        if (tag == null) {
            return;
        }
        int[] pos = tag.getIntArray("pos");
        if (pos.length != 3) {
            return;
        }
        DungeonCompassRenderer.getInstance().render(poseStack, (MultiBufferSource)minecraft.renderBuffers().bufferSource(), (AbstractClientPlayer)player, pos[0], pos[2]);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, AbstractClientPlayer player, int x, int z) {
        if (!Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        RenderSystem.enableDepthTest();
        poseStack.pushPose();
        float ry = (float)Math.PI + player.getYRot() * ((float)Math.PI / 180);
        float cos = Mth.cos((float)ry);
        float sin = Mth.sin((float)ry);
        float mx = 0.75f;
        float mz = -1.0f;
        float vx = mx * cos + mz * -sin;
        float vz = mx * sin + mz * cos;
        poseStack.translate(vx, 0.15f, vz);
        float yaw = (float)Math.PI - (float)Mth.atan2((double)((double)(-x) + player.getX()), (double)((double)z - player.getZ()));
        DungeonCompassRenderer.renderGeoBone(this.bone, this.boneRenderType, poseStack, bufferSource, yaw, false);
        DungeonCompassRenderer.renderGeoBone(this.outline, this.outlineRenderType, poseStack, bufferSource, yaw, true);
        poseStack.popPose();
        RenderSystem.disableDepthTest();
    }

    private static void renderGeoBone(GeoBone geoBone, RenderType renderType, PoseStack poseStack, MultiBufferSource bufferSource, float yaw, boolean yOffset) {
        poseStack.pushPose();
        if (yOffset) {
            geoBone.updatePosition(0.0f, -1.75f, 0.0f);
        }
        geoBone.setRotY(yaw);
        RenderUtil.prepMatrixForBone((PoseStack)poseStack, (GeoBone)geoBone);
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        for (GeoCube cube : geoBone.getCubes()) {
            poseStack.pushPose();
            RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
            RenderUtil.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
            RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
            Matrix3f normalisedPoseState = poseStack.last().normal();
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            for (GeoQuad quad : cube.quads()) {
                if (quad == null) continue;
                Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
                RenderUtil.fixInvertedFlatCube((GeoCube)cube, (Vector3f)normal);
                for (GeoVertex vertex : quad.vertices()) {
                    Vector3f position = vertex.position();
                    Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
                    buffer.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), -1, vertex.texU(), vertex.texV(), OverlayTexture.NO_OVERLAY, 0xF000F0, normal.x(), normal.y(), normal.z());
                }
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

