/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.item.GroupItem;

public class GroupItemExtension
implements IClientItemExtensions {
    public static final GroupItemExtension INSTANCE = new GroupItemExtension();
    private BlockEntityWithoutLevelRenderer renderer;

    private GroupItemExtension() {
    }

    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        if (this.renderer == null) {
            final Minecraft minecraft = Minecraft.getInstance();
            this.renderer = new BlockEntityWithoutLevelRenderer(this, minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

                public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
                    GroupItem.Stacks stacks = (GroupItem.Stacks)stack.get(ModDataComponentTypes.GROUP_STACKS);
                    if (stacks == null) {
                        return;
                    }
                    List<ItemStack> values = stacks.getValues();
                    int size = values.size();
                    if (size == 0) {
                        return;
                    }
                    long time = System.currentTimeMillis();
                    if (time - stacks.lastRenderTime >= 1000L) {
                        stacks.lastRenderTime = time;
                        if (++stacks.lastRenderIndex >= size) {
                            stacks.lastRenderIndex = 0;
                        }
                    }
                    ItemStack itemStack = values.get(stacks.lastRenderIndex);
                    BakedModel bakedModel = minecraft.getItemRenderer().getModel(itemStack, (Level)minecraft.level, (LivingEntity)minecraft.player, 251014);
                    poseStack.pushPose();
                    poseStack.translate(0.5f, 0.5f, 0.5f);
                    minecraft.getItemRenderer().render(itemStack, displayContext, false, poseStack, buffer, packedLight, packedOverlay, bakedModel);
                    poseStack.popPose();
                }
            };
        }
        return this.renderer;
    }
}

