/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import org.confluence.mod.client.renderer.item.NormalArmorItemRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.RenderUtil;

public class MultiHeadArmorItemRenderer<T extends Item>
extends NormalArmorItemRenderer<T> {
    private final T[] headItems;
    protected GeoBone @NotNull [] headBones;

    public MultiHeadArmorItemRenderer(String path, T[] headItems) {
        super(path);
        this.headItems = headItems;
        this.headBones = new GeoBone[headItems.length];
    }

    @Nullable
    public GeoBone getHeadBone(GeoModel<T> model) {
        return null;
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel != bakedModel) {
            this.headBones = new GeoBone[this.headItems.length];
            for (int i = 0; i < this.headItems.length; ++i) {
                this.headBones[i] = this.getGeoModel().getBone(BuiltInRegistries.ITEM.getKey(this.headItems[i]).getPath()).orElse(null);
            }
        }
        super.grabRelevantBones(bakedModel);
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        super.applyBoneVisibilityBySlot(currentSlot);
        if (currentSlot == EquipmentSlot.HEAD) {
            boolean visible = ((HumanoidModel)this).head.visible;
            for (int i = 0; i < this.headItems.length; ++i) {
                if (this.headItems[i] != this.animatable) continue;
                this.setBoneVisible(this.headBones[i], visible);
                break;
            }
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        super.applyBaseTransformations(baseModel);
        for (GeoBone headBone : this.headBones) {
            if (headBone == null) continue;
            ModelPart headPart = baseModel.head;
            RenderUtil.matchModelPartRot((ModelPart)headPart, (GeoBone)headBone);
            headBone.updatePosition(headPart.x, -headPart.y, headPart.z);
        }
    }

    protected void setAllBonesVisible(boolean visible) {
        super.setAllBonesVisible(visible);
        for (GeoBone headBone : this.headBones) {
            this.setBoneVisible(headBone, visible);
        }
    }
}

