/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.confluence.mod.common.init.ModTags;

public class ShortSwordInHandRenderer
implements IClientItemExtensions {
    public static final ShortSwordInHandRenderer INSTANCE = new ShortSwordInHandRenderer();

    private ShortSwordInHandRenderer() {
    }

    public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        if (arm == HumanoidArm.RIGHT && itemInHand.is(ModTags.Items.SHORT_SWORD)) {
            poseStack.translate(0.56f, -0.52f, -0.72f);
            poseStack.mulPose(Axis.XP.rotation(-1.7278761f));
            poseStack.translate(0.0f, Mth.sin((float)(swingProcess * (float)Math.PI)), 0.0f);
            return true;
        }
        return false;
    }

    public static boolean setupAttackAnimation(LivingEntity living, HumanoidModel<?> model) {
        ItemStack stack = living.getMainHandItem();
        if (stack.is(ModTags.Items.SHORT_SWORD)) {
            ModelPart rightArm = model.rightArm;
            rightArm.xRot = -0.86393803f * Mth.sin((float)(model.attackTime * (float)Math.PI));
            rightArm.yRot = 0.0f;
            rightArm.zRot = 0.0f;
            return true;
        }
        return false;
    }

    public static boolean renderArmWithItem(ItemStack stack, ItemDisplayContext context, HumanoidArm arm, PoseStack poseStack, float x, float z, EntityModel<?> parentModel) {
        if (arm == HumanoidArm.RIGHT && context == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND && parentModel instanceof HumanoidModel) {
            HumanoidModel model = (HumanoidModel)parentModel;
            if (stack.is(ModTags.Items.SHORT_SWORD)) {
                poseStack.translate(x, 0.0f, z);
                poseStack.mulPose(Axis.XP.rotation(Mth.sin((float)(model.attackTime * (float)Math.PI)) * 1.5707964f * -0.55f));
                return false;
            }
        }
        return true;
    }
}

