/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import java.util.Hashtable;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.data.saved.BrushData;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.jetbrains.annotations.UnknownNullability;

public class ChunkBrushData
implements INBTSerializable<CompoundTag> {
    private final Map<ChunkPos, BrushData> dataMap = new Hashtable<ChunkPos, BrushData>();

    public Map<ChunkPos, BrushData> getDataMap() {
        return this.dataMap;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<ChunkPos, BrushData> entry : this.dataMap.entrySet()) {
            ChunkPos chunkPos = entry.getKey();
            CompoundTag map = new CompoundTag();
            map.putInt("x", chunkPos.x);
            map.putInt("z", chunkPos.z);
            ListTag data = new ListTag();
            for (Map.Entry<BlockPos, int[]> posEntry : entry.getValue().colors().entrySet()) {
                int[] array = new int[7];
                array[0] = LibUtils.compressRelativePos((BlockPos)posEntry.getKey());
                System.arraycopy(posEntry.getValue(), 0, array, 1, 6);
                data.add((Object)new IntArrayTag(array));
            }
            map.put("data", (Tag)data);
            listTag.add((Object)map);
        }
        nbt.put("dataMap", (Tag)listTag);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.dataMap.clear();
        ListTag listTag = nbt.getList("dataMap", 10);
        for (Tag tag : listTag) {
            CompoundTag map = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(map.getInt("x"), map.getInt("z"));
            Hashtable<BlockPos, int[]> value = new Hashtable<BlockPos, int[]>();
            for (Tag data : map.getList("data", 11)) {
                int[] array = ((IntArrayTag)data).getAsIntArray();
                int[] colors = new int[6];
                System.arraycopy(array, 1, colors, 0, 6);
                value.put(LibUtils.decompressRelativePos((ChunkPos)chunkPos, (int)array[0]), colors);
            }
            this.dataMap.put(chunkPos, new BrushData(value));
        }
    }

    public static ChunkBrushData of(Level level) {
        return (ChunkBrushData)level.getData(ModAttachmentTypes.CHUNK_BRUSH_DATA);
    }
}

