/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.jetbrains.annotations.UnknownNullability;

public class SoulStorage
implements INBTSerializable<CompoundTag> {
    private int soulsCount = 1;
    private int additionalSoul = 0;
    private float currentSoul = 10.0f;
    private float recoveryRatio = 0.0f;
    private transient int maxSoul = -1;

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("soulsCount", this.soulsCount);
        nbt.putInt("additionalSoul", this.additionalSoul);
        nbt.putFloat("currentSoul", this.currentSoul);
        nbt.putFloat("recoveryRatio", this.recoveryRatio);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.soulsCount = nbt.getInt("soulsCount");
        this.additionalSoul = nbt.getInt("additionalSoul");
        this.currentSoul = nbt.getFloat("currentSoul");
        this.recoveryRatio = nbt.getFloat("recoveryRatio");
    }

    public void freshMaxSoul() {
        this.maxSoul = this.soulsCount * 10 + this.additionalSoul;
        if (this.currentSoul > (float)this.maxSoul) {
            this.currentSoul = this.maxSoul;
        }
    }

    public int getMaxSoul() {
        if (this.maxSoul < 0) {
            this.freshMaxSoul();
        }
        return this.maxSoul;
    }

    public float getCurrentSoul() {
        return this.currentSoul;
    }

    public boolean canReceive() {
        return this.currentSoul < (float)this.getMaxSoul();
    }

    public void receive(float additional) {
        if (this.canReceive()) {
            this.currentSoul = this.currentSoul + additional <= (float)this.getMaxSoul() ? (this.currentSoul += additional) : (float)this.getMaxSoul();
        }
    }

    public int getSoulsCount() {
        return this.soulsCount;
    }

    public boolean isSoulMaximun() {
        return this.soulsCount >= 20;
    }

    public void addSoul(int additional) {
        if (!this.isSoulMaximun()) {
            this.soulsCount = this.soulsCount + additional <= 20 ? (this.soulsCount += additional) : 20;
        }
    }

    public float getRecoveryRatio() {
        return this.recoveryRatio;
    }

    public void setRecoveryRatio(float newRecoveryRatio) {
        this.recoveryRatio = newRecoveryRatio;
    }

    public static SoulStorage of(LivingEntity living) {
        return (SoulStorage)living.getData(ModAttachmentTypes.SOUL_STORAGE);
    }
}

