/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseSkullBlock
extends Block {
    public static final int MAX = RotationSegment.getMaxSegmentIndex();
    private static final int ROTATIONS = MAX + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public BaseSkullBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)context.getRotation())));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ROTATION});
    }
}

