/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CrackedBricksBlock
extends Block {
    public CrackedBricksBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.scheduleTick(level, pos);
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        this.scheduleTick(level, hit.getBlockPos());
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        this.scheduleTick(level, pos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.destroyBlock(pos, false);
    }

    public void onDestroyedByPushReaction(BlockState state, Level level, BlockPos pos, Direction pushDirection, FluidState fluid) {
        this.scheduleTick(level, pos);
        super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        if (entity.getDeltaMovement().y > 0.0 && level instanceof Level) {
            Level level1 = (Level)level;
            this.scheduleTick(level1, entity.getOnPosLegacy());
        }
        super.updateEntityAfterFallOn(level, entity);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    private void scheduleTick(Level level, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-7, -7, -7), (BlockPos)pos.offset(7, 7, 7))) {
            level.scheduleTick(blockPos, (Block)this, 1);
        }
    }
}

