/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.common.HoneyBucketItem;
import org.confluence.terra_curio.common.effect.HoneyEffect;

public class HoneyCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<HoneyCauldronBlock> CODEC = HoneyCauldronBlock.simpleCodec(HoneyCauldronBlock::new);
    public static final CauldronInteraction.InteractionMap INTERACTION_MAP = (CauldronInteraction.InteractionMap)Util.make((Object)CauldronInteraction.newInteractionMap((String)"confluence_honey"), map -> {
        Map interactionMap = map.map();
        interactionMap.put(Items.BUCKET, (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.fillBucket((BlockState)blockState, (Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)((HoneyBucketItem)((Object)((Object)((Object)ToolItems.HONEY_BUCKET.get())))).getDefaultInstance(), blockState1 -> true, (SoundEvent)SoundEvents.BUCKET_FILL));
        CauldronInteraction.addDefaultInteractions((Map)interactionMap);
    });
    public static final CauldronInteraction FILL_HONEY = (blockState, level, blockPos, player, hand, itemStack) -> CauldronInteraction.emptyBucket((Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)itemStack, (BlockState)((HoneyCauldronBlock)((Object)((Object)ModBlocks.HONEY_CAULDRON.get()))).defaultBlockState(), (SoundEvent)SoundEvents.BUCKET_EMPTY_LAVA);

    public HoneyCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, INTERACTION_MAP);
    }

    public MapCodec<HoneyCauldronBlock> codec() {
        return CODEC;
    }

    protected double getContentHeight(BlockState blockState) {
        return 0.9375;
    }

    public boolean isFull(BlockState blockState) {
        return true;
    }

    protected void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!level.isClientSide && this.isEntityInsideContent(blockState, blockPos, entity) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            HoneyEffect.applyHoneyEffect((LivingEntity)living);
        }
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return 3;
    }
}

