/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.client.model.block.RelicBlockModel;
import org.confluence.mod.client.renderer.item.SimpleGeoItemRenderer;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RelicBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<RelicBlock> CODEC = RelicBlock.simpleCodec(RelicBlock::new);
    private static final VoxelShape SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);

    public RelicBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<RelicBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity
    implements GeoBlockEntity {
        private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

        public BEntity(BlockPos pos, BlockState state) {
            super(DecorativeBlocks.RELIC_ENTITY.get(), pos, state);
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            RawAnimation running = RawAnimation.begin().thenLoop("running");
            controllers.add(new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(running)));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.cache;
        }
    }

    public static class BItem
    extends BlockItem
    implements GeoItem {
        private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

        public BItem(RelicBlock block) {
            super((Block)block, new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.MASTER));
        }

        public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
            ResourceLocation[] locations = RelicBlockModel.CACHE.get(this.getBlock());
            consumer.accept(new SimpleGeoItemRenderer(locations[0], locations[1], locations[2]));
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.cache;
        }
    }
}

