/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMechanicalBlock
extends Block
implements EntityBlock,
INetworkBlock {
    public AbstractMechanicalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        this.onNodeRemove(state, level, pos, newState);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity
    implements INetworkEntity {
        private NetworkNode networkNode;
        private final Int2ObjectMap<Set<BlockPos>> connectedPoses = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<Set<BlockPos>> relativePoses = new Int2ObjectOpenHashMap();

        public BEntity(BlockEntityType<? extends BEntity> entityType, BlockPos pos, BlockState blockState) {
            super(entityType, pos, blockState);
        }

        public BEntity(BlockPos pos, BlockState state) {
            this(FunctionalBlocks.MECHANICAL_BLOCK_ENTITY.get(), pos, state);
        }

        public void onLoad() {
            super.onLoad();
            this.onNodeLoad();
        }

        public void onChunkUnloaded() {
            super.onChunkUnloaded();
            this.onNodeUnload();
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
            this.deserializePoses(tag, "relativePoses", this.relativePoses);
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            this.serializePoses(tag, "connectedPoses", this.connectedPoses);
            this.serializePoses(tag, "relativePoses", this.relativePoses);
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            return this.serializePoses(new CompoundTag(), "connectedPoses", this.connectedPoses);
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
        }

        @Override
        public BlockEntity getSelf() {
            return this;
        }

        @Override
        public void setNetworkNode(NetworkNode node) {
            this.networkNode = node;
        }

        @Override
        @Nullable
        public NetworkNode getNetworkNode() {
            return this.networkNode;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getConnectedPoses() {
            return this.connectedPoses;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getRelativePoses() {
            return this.relativePoses;
        }
    }
}

