/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public class AnnouncementBoxBlock
extends StandingSignBlock
implements INetworkBlock {
    public static final BlockSetType BLOCK_SET_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("confluence:announcement_box"));
    public static final WoodType WOOD_TYPE = WoodType.register((WoodType)new WoodType("confluence:announcement_box", BLOCK_SET_TYPE));

    public AnnouncementBoxBlock(BlockBehaviour.Properties properties) {
        super(WOOD_TYPE, properties);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        this.onNodeRemove(pState, pLevel, pPos, pNewState);
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.skipInteraction(player.getMainHandItem())) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        BEntity entity = (BEntity)networkEntity;
        if (!level.isClientSide) {
            BEntity.sendMessages(level, pos, entity.getText(true).getMessages(false));
        }
    }

    public static class BEntity
    extends SignBlockEntity
    implements INetworkEntity {
        private NetworkNode networkNode;
        private final Int2ObjectMap<Set<BlockPos>> connectedPoses = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<Set<BlockPos>> relativePoses = new Int2ObjectOpenHashMap();

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.ANNOUNCEMENT_BOX_ENTITY.get(), pos, blockState);
        }

        public void onLoad() {
            super.onLoad();
            this.onNodeLoad();
        }

        public void onChunkUnloaded() {
            super.onChunkUnloaded();
            this.onNodeUnload();
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
            this.deserializePoses(tag, "relativePoses", this.relativePoses);
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            this.serializePoses(tag, "connectedPoses", this.connectedPoses);
            this.serializePoses(tag, "relativePoses", this.relativePoses);
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            return this.serializePoses(new CompoundTag(), "connectedPoses", this.connectedPoses);
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
        }

        @Override
        public BlockEntity getSelf() {
            return this;
        }

        @Override
        public void setNetworkNode(NetworkNode node) {
            this.networkNode = node;
        }

        @Override
        @Nullable
        public NetworkNode getNetworkNode() {
            return this.networkNode;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getConnectedPoses() {
            return this.connectedPoses;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getRelativePoses() {
            return this.relativePoses;
        }

        public static void sendMessages(ServerLevel pLevel, BlockPos pPos, Component[] messages) {
            for (Component text : messages) {
                if (text.getContents() == PlainTextContents.EMPTY) continue;
                Vec3 center = pPos.getCenter();
                int square = Mth.square((int)((Integer)CommonConfigs.ANNOUNCEMENT_BOX_DISTANCE.get()));
                for (Player player : pLevel.players()) {
                    if (!(player.position().distanceToSqr(center) <= (double)square)) continue;
                    player.sendSystemMessage(text);
                }
            }
        }
    }

    public static class Wall
    extends WallSignBlock
    implements INetworkBlock {
        public Wall(BlockBehaviour.Properties properties) {
            super(WOOD_TYPE, properties);
        }

        public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
            this.onNodeRemove(pState, pLevel, pPos, pNewState);
            super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new BEntity(pos, state);
        }

        protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            if (this.skipInteraction(player.getMainHandItem())) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }

        @Override
        public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
            BEntity entity = (BEntity)networkEntity;
            if (!level.isClientSide) {
                BEntity.sendMessages(level, pos, entity.getText(true).getMessages(false));
            }
        }
    }
}

