/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithVerticalFourPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BewitchingTableBlock
extends HorizontalDirectionalWithVerticalFourPartBlock
implements EntityBlock {
    private static final VoxelShape BASE_SHAPE_SOUTH = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)5.0, (double)9.0, (double)2.0, (double)16.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)5.0, (double)8.0, (double)1.5, (double)16.0, (double)9.0, (double)3.5), BewitchingTableBlock.box((double)5.0, (double)8.0, (double)12.5, (double)16.0, (double)9.0, (double)14.5), BewitchingTableBlock.box((double)5.0, (double)9.0, (double)13.0, (double)16.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)2.0, (double)0.0, (double)1.0, (double)5.0, (double)13.0, (double)4.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)3.0, (double)4.0), BewitchingTableBlock.box((double)2.0, (double)0.0, (double)12.0, (double)5.0, (double)13.0, (double)15.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_WEST = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)13.0, (double)9.0, (double)5.0, (double)14.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)12.5, (double)8.0, (double)5.0, (double)14.5, (double)9.0, (double)16.0), BewitchingTableBlock.box((double)1.5, (double)8.0, (double)5.0, (double)3.5, (double)9.0, (double)16.0), BewitchingTableBlock.box((double)2.0, (double)9.0, (double)5.0, (double)3.0, (double)13.0, (double)16.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)2.0, (double)15.0, (double)13.0, (double)5.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)2.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)2.0, (double)4.0, (double)13.0, (double)5.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)2.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_NORTH = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)0.0, (double)9.0, (double)2.0, (double)11.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)0.0, (double)8.0, (double)1.5, (double)11.0, (double)9.0, (double)3.5), BewitchingTableBlock.box((double)0.0, (double)8.0, (double)12.5, (double)11.0, (double)9.0, (double)14.5), BewitchingTableBlock.box((double)0.0, (double)9.0, (double)13.0, (double)11.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)11.0, (double)0.0, (double)1.0, (double)14.0, (double)13.0, (double)4.0), BewitchingTableBlock.box((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), BewitchingTableBlock.box((double)11.0, (double)0.0, (double)12.0, (double)14.0, (double)13.0, (double)15.0), BewitchingTableBlock.box((double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_EAST = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)13.0, (double)9.0, (double)0.0, (double)14.0, (double)13.0, (double)11.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)12.5, (double)8.0, (double)0.0, (double)14.5, (double)9.0, (double)11.0), BewitchingTableBlock.box((double)1.5, (double)8.0, (double)0.0, (double)3.5, (double)9.0, (double)11.0), BewitchingTableBlock.box((double)2.0, (double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)11.0, (double)15.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)11.0, (double)4.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_SOUTH = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)0.0, (double)9.0, (double)2.0, (double)11.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)0.0, (double)8.0, (double)1.5, (double)11.0, (double)9.0, (double)3.5), BewitchingTableBlock.box((double)0.0, (double)8.0, (double)12.5, (double)11.0, (double)9.0, (double)14.5), BewitchingTableBlock.box((double)0.0, (double)9.0, (double)13.0, (double)11.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)11.0, (double)0.0, (double)1.0, (double)14.0, (double)13.0, (double)4.0), BewitchingTableBlock.box((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), BewitchingTableBlock.box((double)11.0, (double)0.0, (double)12.0, (double)14.0, (double)13.0, (double)15.0), BewitchingTableBlock.box((double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_WEST = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)13.0, (double)9.0, (double)0.0, (double)14.0, (double)13.0, (double)11.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)12.5, (double)8.0, (double)0.0, (double)14.5, (double)9.0, (double)11.0), BewitchingTableBlock.box((double)1.5, (double)8.0, (double)0.0, (double)3.5, (double)9.0, (double)11.0), BewitchingTableBlock.box((double)2.0, (double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)11.0, (double)15.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)11.0, (double)4.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_NORTH = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)5.0, (double)9.0, (double)2.0, (double)16.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)5.0, (double)8.0, (double)1.5, (double)16.0, (double)9.0, (double)3.5), BewitchingTableBlock.box((double)5.0, (double)8.0, (double)12.5, (double)16.0, (double)9.0, (double)14.5), BewitchingTableBlock.box((double)5.0, (double)9.0, (double)13.0, (double)16.0, (double)13.0, (double)14.0), BewitchingTableBlock.box((double)2.0, (double)0.0, (double)1.0, (double)5.0, (double)13.0, (double)4.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)3.0, (double)4.0), BewitchingTableBlock.box((double)2.0, (double)0.0, (double)12.0, (double)5.0, (double)13.0, (double)15.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)3.0, (double)15.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_EAST = Shapes.or((VoxelShape)BewitchingTableBlock.box((double)13.0, (double)9.0, (double)5.0, (double)14.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BewitchingTableBlock.box((double)12.5, (double)8.0, (double)5.0, (double)14.5, (double)9.0, (double)16.0), BewitchingTableBlock.box((double)1.5, (double)8.0, (double)5.0, (double)3.5, (double)9.0, (double)16.0), BewitchingTableBlock.box((double)2.0, (double)9.0, (double)5.0, (double)3.0, (double)13.0, (double)16.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)2.0, (double)15.0, (double)13.0, (double)5.0), BewitchingTableBlock.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)2.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)2.0, (double)4.0, (double)13.0, (double)5.0), BewitchingTableBlock.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)2.0), BewitchingTableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape UP_SHAPE = BewitchingTableBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0);
    private static final VoxelShape RIGHT_UP_SHAPE = BewitchingTableBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0);
    private static final VoxelShape[] BASE_SHAPES = new VoxelShape[]{BASE_SHAPE_SOUTH, BASE_SHAPE_WEST, BASE_SHAPE_NORTH, BASE_SHAPE_EAST};
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[]{RIGHT_SHAPE_SOUTH, RIGHT_SHAPE_WEST, RIGHT_SHAPE_NORTH, RIGHT_SHAPE_EAST};

    public BewitchingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        StateProperties.VerticalFourPart part;
        BlockPos basePos;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(basePos = (part = (StateProperties.VerticalFourPart)state.getValue((Property)PART)).isBase() ? pos : (BlockPos)StateProperties.VerticalFourPart.getRelatives((StateProperties.VerticalFourPart)part, (Direction)((Direction)state.getValue((Property)FACING)), (BlockPos)pos).get(StateProperties.VerticalFourPart.BASE))) instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            if (level.getGameTime() - entity.lastClickTime > 110L) {
                entity.lastClickTime = level.getGameTime();
                entity.markUpdated();
                player.addEffect(new MobEffectInstance(ModEffects.BEWITCHED, -1));
                return InteractionResult.SUCCESS_NO_ITEM_USED;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int index = ((Direction)pState.getValue((Property)FACING)).get2DDataValue();
        return switch ((StateProperties.VerticalFourPart)pState.getValue((Property)PART)) {
            default -> throw new MatchException(null, null);
            case StateProperties.VerticalFourPart.BASE -> BASE_SHAPES[index];
            case StateProperties.VerticalFourPart.RIGHT -> RIGHT_SHAPES[index];
            case StateProperties.VerticalFourPart.UP -> UP_SHAPE;
            case StateProperties.VerticalFourPart.RIGHT_UP -> RIGHT_UP_SHAPE;
        };
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static class BEntity
    extends BlockEntity
    implements GeoBlockEntity {
        private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        public final boolean isBase;
        private long lastClickTime;

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.BEWITCHING_TABLE_ENTITY.get(), pos, blockState);
            this.isBase = ((StateProperties.VerticalFourPart)blockState.getValue((Property)HorizontalDirectionalWithVerticalFourPartBlock.PART)).isBase();
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.lastClickTime = tag.getLong("LastClickTime");
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            tag.putLong("LastClickTime", this.lastClickTime);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            tag.putLong("LastClickTime", this.lastClickTime);
            return tag;
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            this.lastClickTime = tag.getLong("LastClickTime");
        }

        public void markUpdated() {
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
        }

        public Packet<ClientGamePacketListener> getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            RawAnimation driving = RawAnimation.begin().thenPlay("driving");
            RawAnimation idling = RawAnimation.begin().thenLoop("idling");
            controllers.add(new AnimationController((GeoAnimatable)this, state -> {
                if (this.level != null && this.level.getGameTime() - this.lastClickTime < 110L) {
                    if (state.isCurrentAnimation(idling)) {
                        return state.setAndContinue(driving);
                    }
                    return PlayState.CONTINUE;
                }
                return state.setAndContinue(idling);
            }));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.cache;
        }
    }
}

