/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.AbstractDispenserMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModSecretSeeds;

public class DartTrapBlock
extends AbstractDispenserMechanicalBlock {
    public static final ItemStack PICKUP_ITEM_STACK = Items.SPECTRAL_ARROW.getDefaultInstance();
    public static final Component NAME = Component.translatable((String)"entity.confluence.dart");

    public DartTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean behaviour(BlockState pState, ServerLevel pLevel, BlockPos pPos, int pColor, INetworkEntity pEntity) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        double x = (double)pPos.getX() + 0.5 + 0.7 * (double)direction.getStepX();
        double y = (double)pPos.getY() + 0.5 + 0.7 * (double)direction.getStepY();
        double z = (double)pPos.getZ() + 0.5 + 0.7 * (double)direction.getStepZ();
        Arrow arrow = new Arrow((Level)pLevel, x, y, z, PICKUP_ITEM_STACK, null);
        arrow.setCustomName(NAME);
        arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        arrow.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)LibUtils.switchByDifficulty((Level)pLevel, (BlockPos)pPos, (Object)300, (Object)600, (Object)750)).intValue(), 1));
        if (ModSecretSeeds.NO_TRAPS.match(pLevel)) {
            arrow.addEffect(new MobEffectInstance(ModEffects.BLEEDING, 1200, 1));
        }
        arrow.setBaseDamage(1.0);
        arrow.shoot((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), 3.0f, 0.0f);
        return pLevel.addFreshEntity((Entity)arrow);
    }

    @Override
    protected int delay() {
        return 20;
    }
}

