/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;

public class DetonatorBlock
extends AbstractMechanicalBlock {
    private static final VoxelShape DRIVE = DetonatorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final AABB TOUCH_AABB = new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final Predicate<Entity> PREDICATE = EntitySelector.NO_SPECTATORS.and(entity -> !entity.isIgnoringBlockTriggers());

    public DetonatorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false))).setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{StateProperties.SIGNAL, StateProperties.DRIVE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)StateProperties.DRIVE) != false ? DRIVE : Shapes.block();
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!pLevel.isClientSide && pLevel.hasNeighborSignal(pPos)) {
            this.execute(pState, (ServerLevel)pLevel, pPos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance);
        if (fallDistance > 2.0f && !((Boolean)state.getValue((Property)StateProperties.DRIVE)).booleanValue() && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(true))).setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(true)));
            this.execute(state, serverPlayer.serverLevel(), pos, true);
            level.scheduleTick(pos, (Block)this, 20);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)StateProperties.DRIVE)).booleanValue()) {
            AbstractMechanicalBlock.BEntity entity;
            BlockEntity blockEntity;
            if (!level.getEntitiesOfClass(LivingEntity.class, TOUCH_AABB.move(pos), PREDICATE).isEmpty() || (blockEntity = level.getBlockEntity(pos)) instanceof AbstractMechanicalBlock.BEntity && (entity = (AbstractMechanicalBlock.BEntity)blockEntity).getOrCreateNetworkNode().hasSignal(pos)) {
                level.scheduleTick(pos, (Block)this, 20);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false))).setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
    }
}

