/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import org.confluence.lib.common.block.ISimulatorBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.handler.ClientPacketHandler;

public class EchoBlock
extends HalfTransparentBlock
implements ISimulatorBlock {
    public EchoBlock() {
        super(BlockBehaviour.Properties.of().isSuffocating((blockState, blockGetter, blockPos) -> false).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        EntityCollisionContext context1;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (context1 = (EntityCollisionContext)context).getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (player.isLocalPlayer()) {
                return ClientPacketHandler.hasEchoVisible() ? Shapes.block() : Shapes.empty();
            }
            return LibUtils.getOrCreatePersistedData((Player)player).getBoolean("confluence:has_echo_visibility") ? Shapes.block() : Shapes.empty();
        }
        return Shapes.block();
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getShape(pState, pLevel, pPos, pContext);
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{StateProperties.VISIBLE});
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public BlockState getSimulatedBlock(boolean isClient) {
        if (isClient && FMLEnvironment.dist.isClient()) {
            return (BlockState)this.defaultBlockState().setValue((Property)StateProperties.VISIBLE, (Comparable)Boolean.valueOf(ClientPacketHandler.hasEchoVisible()));
        }
        return this.defaultBlockState();
    }
}

