/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipBlockItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.MobEffectInstanceData;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public class EffectiveCandleBlock
extends AbstractMechanicalBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)EffectiveCandleBlock.box((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), (VoxelShape)EffectiveCandleBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0));
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private final float scopeSqr;
    private final MobEffectInstanceData[] effectData;

    public EffectiveCandleBlock(BlockBehaviour.Properties properties, float scope, MobEffectInstanceData ... effectData) {
        super(properties);
        this.scopeSqr = scope * scope;
        this.effectData = effectData;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.WEST));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        EffectiveCandleBlock.switchStatus((Level)level, state, pos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        EffectiveCandleBlock.switchStatus(level, state, pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EffectiveCandleBlock.switchStatus(level, state, pos);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static void switchStatus(Level level, BlockState state, BlockPos pos) {
        if (!level.isClientSide) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : LibUtils.getTicker(blockEntityType, FunctionalBlocks.MECHANICAL_BLOCK_ENTITY.get(), (level1, pos, state1, blockEntity) -> {
            if (level1 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level1;
                if (level.getGameTime() % 40L == 5L) {
                    double x = (double)pos.getX() + 0.5;
                    double y = (double)pos.getY() + 0.5;
                    double z = (double)pos.getZ() + 0.5;
                    for (ServerPlayer player : serverLevel.players()) {
                        if (!(player.distanceToSqr(x, y, z) <= (double)this.scopeSqr)) continue;
                        EffectiveCandleBlock.awardEffect((LivingEntity)player, this.effectData);
                    }
                }
            }
        });
    }

    private static void awardEffect(LivingEntity living, MobEffectInstanceData[] dat) {
        for (MobEffectInstanceData data : dat) {
            MobEffectInstance instance = (MobEffectInstance)living.getActiveEffectsMap().get(data.effect());
            if (instance != null && instance.duration >= 50) continue;
            living.addEffect(data.create());
        }
    }

    public static class BItem
    extends TooltipBlockItem {
        public final MobEffectInstanceData[] effectData;

        public BItem(Block block, ModRarity rarity, List<Component> tooltips, MobEffectInstanceData ... effectData) {
            super(block, new Item.Properties(), rarity, tooltips);
            this.effectData = effectData;
        }

        public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
            if (isSelected && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EffectiveCandleBlock.awardEffect(living, this.effectData);
            }
        }
    }
}

