/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.ISimulatorBlock;
import org.confluence.lib.common.block.StateProperties;
import org.jetbrains.annotations.Nullable;

public class FragileBlock
extends Block
implements ISimulatorBlock {
    private final Supplier<BlockState> simulatorBlock;

    public FragileBlock(BlockBehaviour.Properties pProperties, Supplier<BlockState> simulatorBlock) {
        super(pProperties);
        this.simulatorBlock = simulatorBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{StateProperties.IS_SUPPORTING, BlockStateProperties.FACING});
    }

    public BlockState getSimulatedBlock(boolean isClient) {
        return this.simulatorBlock.get();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()));
        BlockState state = this.defaultBlockState();
        if (blockState.hasProperty((Property)StateProperties.IS_SUPPORTING)) {
            state = (BlockState)state.setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState blockState;
        if (!(level.isClientSide() || ((Boolean)state.getValue((Property)StateProperties.IS_SUPPORTING)).booleanValue() || (blockState = level.getBlockState(pos.relative((Direction)state.getValue((Property)BlockStateProperties.FACING)))).hasProperty((Property)StateProperties.IS_SUPPORTING))) {
            level.destroyBlock(pos, false);
        }
        return state;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.simulatorBlock.get().getShape(level, pos, context);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

