/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.ISimulatorBlock;
import org.confluence.mod.common.block.functional.BehaviourPressurePlateBlock;

public class FragilePressureBlock
extends BehaviourPressurePlateBlock
implements ISimulatorBlock {
    private static final AABB TOUCH_AABB = new AABB(0.0, 1.0, 0.0, 1.0, 2.0, 1.0);
    private final Supplier<BlockState> simulatorBlock;

    public FragilePressureBlock(BlockBehaviour.Properties pProperties, BlockSetType pType, Supplier<BlockState> simulatorBlock) {
        super(new BehaviourPressurePlateBlock.Behaviour(){

            @Override
            protected int getSignalStrength(Level level, BlockPos blockPos) {
                AABB aabb = TOUCH_AABB.move(blockPos);
                for (Player player : level.players()) {
                    if (!aabb.contains(player.position())) continue;
                    return 15;
                }
                return 0;
            }
        }, pProperties, pType);
        this.simulatorBlock = simulatorBlock;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.simulatorBlock.get().getShape(level, pos, context);
    }

    @Override
    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.entityInside(state, level, pos, entity);
    }

    public BlockState getSimulatedBlock(boolean isClient) {
        return this.simulatorBlock.get();
    }
}

