/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public class HeartLanternBlock
extends LanternBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape NORMAL_SHAPE = Shapes.or((VoxelShape)HeartLanternBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), (VoxelShape[])new VoxelShape[]{HeartLanternBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), HeartLanternBlock.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0)});
    private static final VoxelShape HANGING_SHAPE = Shapes.or((VoxelShape)HeartLanternBlock.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), (VoxelShape[])new VoxelShape[]{HeartLanternBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), HeartLanternBlock.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)});

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)HANGING) != false ? HANGING_SHAPE : NORMAL_SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.getRotation((Direction)state.getValue((Property)FACING)).rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState baseState = super.getStateForPlacement(context);
        if (baseState == null) {
            return null;
        }
        Direction playerFacing = context.getHorizontalDirection().getOpposite();
        return (BlockState)baseState.setValue((Property)FACING, (Comparable)playerFacing);
    }

    public HeartLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        if (blockEntityType != FunctionalBlocks.HEART_LANTERN_ENTITY.get()) {
            return null;
        }
        return (level1, pos, state1, blockEntity) -> {
            ServerLevel serverLevel;
            if (level1 instanceof ServerLevel && (serverLevel = (ServerLevel)level1).getGameTime() % 200L == 0L) {
                Vec3 center = pos.getCenter();
                for (Player player : serverLevel.players()) {
                    if (!(player.distanceToSqr(center) < 1024.0)) continue;
                    player.addEffect(new MobEffectInstance(ModEffects.HEART_LANTERN, 420));
                }
            }
        };
    }

    public static class BEntity
    extends BlockEntity {
        public BEntity(BlockPos pos, BlockState state) {
            super(FunctionalBlocks.HEART_LANTERN_ENTITY.get(), pos, state);
        }
    }
}

