/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.PlayerContainer;
import org.confluence.lib.common.block.HorizontalDirectionalWaterloggedBlock;
import org.confluence.mod.common.attachment.PlayerPiggyBankContainer;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class PiggyBankBlock
extends HorizontalDirectionalWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_X = PiggyBankBlock.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_Z = PiggyBankBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)10.0, (double)14.0);

    public PiggyBankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected SoundType getSoundType(BlockState p_277561_) {
        return SoundType.DECORATED_POT;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            PlayerPiggyBankContainer container = PlayerPiggyBankContainer.of(player);
            container.setActiveContainer(entity);
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new ChestMenu(MenuType.GENERIC_9x6, id, inventory, (Container)container, 6), (Component)Component.translatable((String)"container.confluence.piggy_bank")));
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            level.playSound(null, pos, SoundEvents.PIG_AMBIENT, SoundSource.BLOCKS);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity
    implements PlayerContainer.ValidEntity {
        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.PIGGY_BANK_ENTITY.get(), pos, blockState);
        }

        public BlockEntity self() {
            return this;
        }
    }
}

