/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.PlayerContainer;
import org.confluence.lib.common.block.HorizontalDirectionalWaterloggedBlock;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.attachment.PlayerSafeContainer;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SafeBlock
extends HorizontalDirectionalWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = SafeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public SafeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.OPEN}));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            PlayerSafeContainer container = PlayerSafeContainer.of(player);
            container.setActiveContainer(entity);
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new ChestMenu(MenuType.GENERIC_9x6, id, inventory, (Container)container, 6), (Component)Component.translatable((String)"container.confluence.safe")));
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : LibUtils.getTicker(blockEntityType, FunctionalBlocks.SAFE_ENTITY.get(), BEntity::serverTick);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity
    implements PlayerContainer.ValidEntity,
    GeoBlockEntity {
        private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

            protected void onOpen(Level level, BlockPos pos, BlockState state) {
                this.triggerAnim("status", "open");
            }

            protected void onClose(Level level, BlockPos pos, BlockState state) {
                this.triggerAnim("status", "close");
            }

            protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
            }

            protected boolean isOwnContainer(Player player) {
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof ChestMenu) {
                    ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
                    return chestMenu.getContainer() == PlayerSafeContainer.of(player);
                }
                return false;
            }
        };

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.SAFE_ENTITY.get(), pos, blockState);
            SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        }

        public BlockEntity self() {
            return this;
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            controllers.add(new AnimationController((GeoAnimatable)this, "status", 1, state -> PlayState.STOP).triggerableAnim("open", RawAnimation.begin().thenPlayAndHold("open")).triggerableAnim("close", RawAnimation.begin().thenPlayAndHold("close")));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.CACHE;
        }

        public static void serverTick(Level level, BlockPos pos, BlockState state, BEntity entity) {
            if (!entity.remove) {
                entity.openersCounter.recheckOpeners(level, pos, state);
            }
        }
    }
}

