/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class TuffBoothBlock
extends BaseEntityBlock {
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)16);
    public static final BooleanProperty SHOW_NAME = BooleanProperty.create((String)"show_name");
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)TuffBoothBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), (VoxelShape[])new VoxelShape[]{TuffBoothBlock.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), TuffBoothBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), TuffBoothBlock.box((double)1.0, (double)3.0, (double)12.0, (double)4.0, (double)5.0, (double)15.0), TuffBoothBlock.box((double)12.0, (double)3.0, (double)12.0, (double)15.0, (double)5.0, (double)15.0), TuffBoothBlock.box((double)12.0, (double)3.0, (double)1.0, (double)15.0, (double)5.0, (double)4.0), TuffBoothBlock.box((double)1.0, (double)3.0, (double)1.0, (double)4.0, (double)5.0, (double)4.0)});
    private static final BiMap<Item, Integer> CARPET_TO_COLOR = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)Items.WHITE_CARPET, (Object)1);
        map.put((Object)Items.LIGHT_GRAY_CARPET, (Object)2);
        map.put((Object)Items.GRAY_CARPET, (Object)3);
        map.put((Object)Items.BLACK_CARPET, (Object)4);
        map.put((Object)Items.BROWN_CARPET, (Object)5);
        map.put((Object)Items.RED_CARPET, (Object)6);
        map.put((Object)Items.ORANGE_CARPET, (Object)7);
        map.put((Object)Items.YELLOW_CARPET, (Object)8);
        map.put((Object)Items.LIME_CARPET, (Object)9);
        map.put((Object)Items.GREEN_CARPET, (Object)10);
        map.put((Object)Items.CYAN_CARPET, (Object)11);
        map.put((Object)Items.LIGHT_BLUE_CARPET, (Object)12);
        map.put((Object)Items.BLUE_CARPET, (Object)13);
        map.put((Object)Items.PURPLE_CARPET, (Object)14);
        map.put((Object)Items.MAGENTA_CARPET, (Object)15);
        map.put((Object)Items.PINK_CARPET, (Object)16);
    });

    public TuffBoothBlock(BlockBehaviour.Properties p_309186_) {
        super(p_309186_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)COLOR, (Comparable)Integer.valueOf(0))).setValue((Property)SHOW_NAME, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, SHOW_NAME});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TuffBoothBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return TuffBoothBlock.simpleCodec(TuffBoothBlock::new);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!newState.isAir()) {
            super.onRemove(state, level, pos, newState, movedByPiston);
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TuffBoothBlockEntity) {
            TuffBoothBlockEntity boothEntity = (TuffBoothBlockEntity)blockEntity;
            ItemStack stackToDrop = boothEntity.getItemHandler().getStackInSlot(0);
            if (!stackToDrop.isEmpty()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stackToDrop);
            }
            if (((Boolean)state.getValue((Property)SHOW_NAME)).booleanValue()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)Items.NAME_TAG.getDefaultInstance());
            }
            if ((Integer)state.getValue((Property)COLOR) != 0) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)Objects.requireNonNull((Item)CARPET_TO_COLOR.inverse().get((Object)state.getValue((Property)COLOR))).getDefaultInstance());
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TuffBoothBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        TuffBoothBlockEntity boothEntity = (TuffBoothBlockEntity)blockEntity;
        ItemStackHandler itemHandler = boothEntity.getItemHandler();
        ItemStack boothItem = itemHandler.getStackInSlot(0);
        if (hit.getLocation().y - (double)pos.getY() > 0.5) {
            if (!stack.isEmpty()) {
                if (!boothItem.isEmpty() && !player.getInventory().add(boothItem)) {
                    player.drop(boothItem, false);
                }
                ItemStack oneItem = stack.split(1);
                itemHandler.setStackInSlot(0, oneItem);
            } else if (!boothItem.isEmpty()) {
                player.setItemInHand(hand, boothItem.copy());
                itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            }
            TuffBoothBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)boothEntity.getBlockState());
        } else if (!stack.isEmpty()) {
            if (CARPET_TO_COLOR.containsKey((Object)stack.getItem())) {
                int newColor;
                int currentColor = (Integer)state.getValue((Property)COLOR);
                if (currentColor != (newColor = Objects.requireNonNull((Integer)CARPET_TO_COLOR.get((Object)stack.getItem())).intValue())) {
                    stack.shrink(1);
                    if (currentColor != 0) {
                        ItemStack oldCarpet = Objects.requireNonNull((Item)CARPET_TO_COLOR.inverse().get((Object)currentColor)).getDefaultInstance();
                        if (!player.getInventory().add(oldCarpet)) {
                            player.drop(oldCarpet, false);
                        }
                    }
                    level.setBlock(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(newColor)), 3);
                }
            } else if (stack.is(Items.NAME_TAG) && !((Boolean)state.getValue((Property)SHOW_NAME)).booleanValue()) {
                stack.shrink(1);
                level.setBlock(pos, (BlockState)state.setValue((Property)SHOW_NAME, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            boolean stateChanged = false;
            BlockState newState = state;
            int currentColor = (Integer)state.getValue((Property)COLOR);
            if (currentColor != 0) {
                ItemStack carpetStack = Objects.requireNonNull((Item)CARPET_TO_COLOR.inverse().get((Object)currentColor)).getDefaultInstance();
                if (!player.getInventory().add(carpetStack)) {
                    player.drop(carpetStack, false);
                }
                newState = (BlockState)newState.setValue((Property)COLOR, (Comparable)Integer.valueOf(0));
                stateChanged = true;
            }
            if (((Boolean)newState.getValue((Property)SHOW_NAME)).booleanValue()) {
                ItemStack nameTagStack = Items.NAME_TAG.getDefaultInstance();
                if (!player.getInventory().add(nameTagStack)) {
                    player.drop(nameTagStack, false);
                }
                newState = (BlockState)newState.setValue((Property)SHOW_NAME, (Comparable)Boolean.valueOf(false));
                stateChanged = true;
            }
            if (stateChanged) {
                level.setBlock(pos, newState, 3);
            }
        }
        boothEntity.setChanged();
        return ItemInteractionResult.sidedSuccess((boolean)false);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public static class TuffBoothBlockEntity
    extends BlockEntity {
        private final ItemStackHandler itemHandler = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                this.setChanged();
                if (level != null) {
                    level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                }
            }
        };

        public TuffBoothBlockEntity(BlockPos pos, BlockState state) {
            super(FunctionalBlocks.TUFF_BOOTH_ENTITY.get(), pos, state);
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public ItemStackHandler getItemHandler() {
            return this.itemHandler;
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            return this.saveWithoutMetadata(registries);
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
            this.loadAdditional(tag, registries);
        }

        public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            if (tag.contains("inv")) {
                this.itemHandler.deserializeNBT(registries, tag.getCompound("inv"));
            }
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            tag.put("inv", (Tag)this.itemHandler.serializeNBT(registries));
        }
    }
}

