/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithVerticalFourPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.menu.AlchemyTableMenu;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableBlock
extends HorizontalDirectionalWithVerticalFourPartBlock {
    private static final VoxelShape BASE_SHAPE_SOUTH = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)5.0, (double)3.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)15.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_WEST = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)2.0, (double)3.0, (double)5.0, (double)14.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)16.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_NORTH = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)0.0, (double)3.0, (double)2.0, (double)11.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)15.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_EAST = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)14.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_SOUTH = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)0.0, (double)3.0, (double)2.0, (double)11.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)3.0, (double)15.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_WEST = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)14.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_NORTH = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)5.0, (double)3.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)15.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_EAST = Shapes.or((VoxelShape)AlchemyTableBlock.box((double)2.0, (double)3.0, (double)5.0, (double)14.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AlchemyTableBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)16.0), AlchemyTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape UP_SHAPE = AlchemyTableBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0);
    private static final VoxelShape RIGHT_UP_SHAPE = AlchemyTableBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0);
    private static final VoxelShape[] BASE_SHAPES = new VoxelShape[]{BASE_SHAPE_SOUTH, BASE_SHAPE_WEST, BASE_SHAPE_NORTH, BASE_SHAPE_EAST};
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[]{RIGHT_SHAPE_SOUTH, RIGHT_SHAPE_WEST, RIGHT_SHAPE_NORTH, RIGHT_SHAPE_EAST};

    public AlchemyTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState pState, Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((pContainerId, pPlayerInventory, pPlayer) -> new AlchemyTableMenu(pContainerId, pPlayerInventory, ContainerLevelAccess.create((Level)pLevel, (BlockPos)pPos)), (Component)Component.translatable((String)"container.confluence.alchemy_table"));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int index = ((Direction)pState.getValue((Property)FACING)).get2DDataValue();
        return switch ((StateProperties.VerticalFourPart)pState.getValue((Property)PART)) {
            default -> throw new MatchException(null, null);
            case StateProperties.VerticalFourPart.BASE -> BASE_SHAPES[index];
            case StateProperties.VerticalFourPart.RIGHT -> RIGHT_SHAPES[index];
            case StateProperties.VerticalFourPart.UP -> UP_SHAPE;
            case StateProperties.VerticalFourPart.RIGHT_UP -> RIGHT_UP_SHAPE;
        };
    }
}

