/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithHorizontalTwoPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipBlockItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.renderer.block.ExtractinatorBlockRenderer;
import org.confluence.mod.client.renderer.item.SimpleGeoItemRenderer;
import org.confluence.mod.common.data.map.ExtractinatorData;
import org.confluence.mod.common.init.ModDataMaps;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.terra_curio.mixin.client.accessor.MinecraftAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExtractinatorBlock
extends HorizontalDirectionalWithHorizontalTwoPartBlock
implements EntityBlock {
    private static final VoxelShape BASE_SHAPE_SOUTH = ExtractinatorBlock.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE_WEST = ExtractinatorBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape BASE_SHAPE_NORTH = ExtractinatorBlock.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE_EAST = ExtractinatorBlock.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_SOUTH = ExtractinatorBlock.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_WEST = ExtractinatorBlock.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_NORTH = ExtractinatorBlock.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_EAST = ExtractinatorBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape[] BASE_SHAPES = new VoxelShape[]{BASE_SHAPE_SOUTH, BASE_SHAPE_WEST, BASE_SHAPE_NORTH, BASE_SHAPE_EAST};
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[]{RIGHT_SHAPE_SOUTH, RIGHT_SHAPE_WEST, RIGHT_SHAPE_NORTH, RIGHT_SHAPE_EAST};

    public ExtractinatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return ((StateProperties.HorizontalTwoPart)state.getValue((Property)PART)).isBase() ? BASE_SHAPES[index] : RIGHT_SHAPES[index];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = player.getItemInHand(hand);
            ExtractinatorData data = (ExtractinatorData)itemStack.getItemHolder().getData(ModDataMaps.EXTRACTINATOR);
            if (data == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ExtractinatorData.extract(level, pos, player, hand, serverLevel, itemStack, data);
        } else if (LibUtils.isPhysicalClient()) {
            ((MinecraftAccessor)Minecraft.getInstance()).setRightClickDelay(1);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static class BEntity
    extends BlockEntity
    implements GeoBlockEntity {
        private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        public final boolean isBase;

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.EXTRACTINATOR_ENTITY.get(), pos, blockState);
            this.isBase = ((StateProperties.HorizontalTwoPart)blockState.getValue((Property)HorizontalDirectionalWithHorizontalTwoPartBlock.PART)).isBase();
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            controllers.add(new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenLoop("default"))));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.CACHE;
        }
    }

    public static class BItem
    extends TooltipBlockItem
    implements GeoItem {
        private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

        public BItem(ExtractinatorBlock block) {
            super((Block)block, new Item.Properties(), ModRarity.WHITE, "tooltip.item.confluence.extractinator.0");
        }

        public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
            consumer.accept(new SimpleGeoItemRenderer(ExtractinatorBlockRenderer.MODEL, ExtractinatorBlockRenderer.TEXTURE, ExtractinatorBlockRenderer.ANIMATION));
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.CACHE;
        }
    }
}

