/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.lib.common.recipe.ArrayRecipeInput;
import org.confluence.mod.common.block.functional.crafting.EnhancedForgeBlock;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.menu.HardmodeForgeMenu;
import org.confluence.mod.common.recipe.EnhancedForgeRecipe;
import org.confluence.mod.common.recipe.HardmodeForgeRecipe;
import org.confluence.mod.common.recipe.HellforgeRecipe;
import org.jetbrains.annotations.Nullable;

public class HardmodeForgeBlock
extends EnhancedForgeBlock {
    public HardmodeForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    protected BlockEntityType<BEntity> getBlockEntityType() {
        return FunctionalBlocks.HARDMODE_FORGE_ENTITY.get();
    }

    @Override
    protected <T extends EnhancedForgeRecipe> boolean isForgeMatched(Level level, EnhancedForgeBlock.BEntity<T> entity, ItemStack[] itemStacks, boolean[] data) {
        RecipeHolder recipeholder = null;
        if (entity instanceof BEntity) {
            BEntity bEntity = (BEntity)entity;
            recipeholder = bEntity.hellforge.getRecipeFor((RecipeInput)new ArrayRecipeInput(itemStacks), level).orElse(null);
        }
        if (recipeholder == null) {
            recipeholder = entity.forge.getRecipeFor((RecipeInput)new ArrayRecipeInput(itemStacks), level).orElse(null);
        }
        if (recipeholder != null) {
            if (!entity.isLit() && entity.canForgeBurn(recipeholder)) {
                data[0] = entity.doUpdateStatus();
            }
            if (entity.canForgeBurn(recipeholder)) {
                if (entity.doUpdateProgress(recipeholder, entity::burnForge)) {
                    data[0] = true;
                }
            }
            return true;
        }
        return false;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = pos.getY();
        double d2 = (double)pos.getZ() + 0.5;
        if (random.nextDouble() < 0.1) {
            level.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public static class BEntity
    extends EnhancedForgeBlock.BEntity<HardmodeForgeRecipe> {
        protected final RecipeManager.CachedCheck<RecipeInput, HellforgeRecipe> hellforge = BEntity.createCachedCheck(ModRecipes.HELLFORGE_TYPE.get());

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.HARDMODE_FORGE_ENTITY.get(), pos, blockState);
        }

        @Override
        protected RecipeType<HardmodeForgeRecipe> getRecipeType() {
            return ModRecipes.HARDMODE_FORGE_TYPE.get();
        }

        @Override
        protected AbstractContainerMenu newMenu(int containerId, Inventory inventory, Container forgeContainer, ContainerData forgeData) {
            return new HardmodeForgeMenu(containerId, inventory, forgeContainer, forgeData);
        }

        protected Component getDefaultName() {
            return Component.translatable((String)("container.confluence." + BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock()).getPath()));
        }

        @Override
        protected int getTotalCookTime() {
            int time = this.forge.getRecipeFor((RecipeInput)new ArrayRecipeInput(this.getItemStacks()), this.level).map(holder -> ((HardmodeForgeRecipe)holder.value()).getCookingTime()).orElse(50);
            return ((ItemStack)this.items.get(4)).isEmpty() ? time * 4 : time;
        }
    }
}

