/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithVerticalFourPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.common.recipe.EnvironmentLevelAccess;
import org.confluence.mod.common.menu.HeavyWorkBenchMenu;
import org.jetbrains.annotations.Nullable;

public class HeavyWorkBenchBlock
extends HorizontalDirectionalWithVerticalFourPartBlock {
    private static final VoxelShape BASE_SHAPE_SOUTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)13.0, (double)4.0, (double)4.0, (double)16.0), HeavyWorkBenchBlock.box((double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)13.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_WEST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)13.0, (double)4.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)13.0, (double)16.0), HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)4.0, (double)4.0), HeavyWorkBenchBlock.box((double)3.0, (double)0.0, (double)4.0, (double)14.0, (double)13.0, (double)14.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_NORTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)12.0, (double)0.0, (double)3.0, (double)14.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)13.0, (double)16.0), HeavyWorkBenchBlock.box((double)12.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0), HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)3.0, (double)12.0, (double)13.0, (double)14.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape BASE_SHAPE_EAST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)12.0, (double)13.0, (double)13.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)12.0), HeavyWorkBenchBlock.box((double)13.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)14.0), HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)13.0, (double)12.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_SOUTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)12.0, (double)0.0, (double)0.0, (double)14.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)13.0, (double)2.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), HeavyWorkBenchBlock.box((double)12.0, (double)0.0, (double)13.0, (double)14.0, (double)4.0, (double)16.0)});
    private static final VoxelShape RIGHT_SHAPE_WEST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)3.0, (double)0.0, (double)12.0, (double)16.0, (double)13.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)12.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)4.0, (double)14.0)});
    private static final VoxelShape RIGHT_SHAPE_NORTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)3.0, (double)4.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)4.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)3.0)});
    private static final VoxelShape RIGHT_SHAPE_EAST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)13.0, (double)4.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)13.0, (double)16.0), HeavyWorkBenchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), HeavyWorkBenchBlock.box((double)13.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)4.0)});
    private static final VoxelShape UP_SHAPE_SOUTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)6.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0)});
    private static final VoxelShape UP_SHAPE_WEST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)3.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)3.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)13.0, (double)16.0), HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0)});
    private static final VoxelShape UP_SHAPE_NORTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)13.0, (double)0.0, (double)3.0, (double)15.0, (double)6.0, (double)14.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)14.0, (double)15.0, (double)13.0, (double)16.0), HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0)});
    private static final VoxelShape UP_SHAPE_EAST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)2.0, (double)0.0, (double)13.0, (double)13.0, (double)6.0, (double)15.0), (VoxelShape[])new VoxelShape[]{HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)15.0), HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0)});
    private static final VoxelShape RIGHT_UP_SHAPE_SOUTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)13.0, (double)2.0), (VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0));
    private static final VoxelShape RIGHT_UP_SHAPE_WEST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), (VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0));
    private static final VoxelShape RIGHT_UP_SHAPE_NORTH = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)1.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0));
    private static final VoxelShape RIGHT_UP_SHAPE_EAST = Shapes.or((VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)13.0, (double)16.0), (VoxelShape)HeavyWorkBenchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.02, (double)16.0));
    private static final VoxelShape[] BASE_SHAPES = new VoxelShape[]{BASE_SHAPE_SOUTH, BASE_SHAPE_WEST, BASE_SHAPE_NORTH, BASE_SHAPE_EAST};
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[]{RIGHT_SHAPE_SOUTH, RIGHT_SHAPE_WEST, RIGHT_SHAPE_NORTH, RIGHT_SHAPE_EAST};
    private static final VoxelShape[] UP_SHAPES = new VoxelShape[]{UP_SHAPE_SOUTH, UP_SHAPE_WEST, UP_SHAPE_NORTH, UP_SHAPE_EAST};
    private static final VoxelShape[] RIGHT_UP_SHAPES = new VoxelShape[]{RIGHT_UP_SHAPE_SOUTH, RIGHT_UP_SHAPE_WEST, RIGHT_UP_SHAPE_NORTH, RIGHT_UP_SHAPE_EAST};

    public HeavyWorkBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((containerId, inventory, player) -> new HeavyWorkBenchMenu(containerId, inventory, new EnvironmentLevelAccess(level, pos)), (Component)Component.translatable((String)"container.confluence.heavy_work_bench"));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return switch ((StateProperties.VerticalFourPart)state.getValue((Property)PART)) {
            default -> throw new MatchException(null, null);
            case StateProperties.VerticalFourPart.BASE -> BASE_SHAPES[index];
            case StateProperties.VerticalFourPart.RIGHT -> RIGHT_SHAPES[index];
            case StateProperties.VerticalFourPart.UP -> UP_SHAPES[index];
            case StateProperties.VerticalFourPart.RIGHT_UP -> RIGHT_UP_SHAPES[index];
        };
    }
}

