/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.item.PotionItems;
import org.jetbrains.annotations.Nullable;

public class KegBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<KegBlock> CODEC = KegBlock.simpleCodec(KegBlock::new);
    private static final VoxelShape X_AXIS_SHAPE = Shapes.or((VoxelShape)KegBlock.box((double)1.0, (double)5.5, (double)3.0, (double)15.0, (double)15.5, (double)13.0), (VoxelShape[])new VoxelShape[]{KegBlock.box((double)10.5, (double)5.0, (double)2.5, (double)12.5, (double)9.0, (double)13.5), KegBlock.box((double)10.5, (double)0.0, (double)10.0, (double)12.5, (double)5.0, (double)12.0), KegBlock.box((double)10.5, (double)0.0, (double)4.0, (double)12.5, (double)5.0, (double)6.0), KegBlock.box((double)11.0, (double)1.5, (double)6.0, (double)12.0, (double)3.5, (double)10.0), KegBlock.box((double)3.5, (double)5.0, (double)2.5, (double)5.5, (double)9.0, (double)13.5), KegBlock.box((double)3.5, (double)0.0, (double)10.0, (double)5.5, (double)5.0, (double)12.0), KegBlock.box((double)3.5, (double)0.0, (double)4.0, (double)5.5, (double)5.0, (double)6.0), KegBlock.box((double)4.0, (double)1.5, (double)6.0, (double)5.0, (double)3.5, (double)10.0)});
    private static final VoxelShape Z_AXIS_SHAPE = Shapes.or((VoxelShape)KegBlock.box((double)3.0, (double)5.5, (double)1.0, (double)13.0, (double)15.5, (double)15.0), (VoxelShape[])new VoxelShape[]{KegBlock.box((double)2.5, (double)5.0, (double)10.5, (double)13.5, (double)9.0, (double)12.5), KegBlock.box((double)4.0, (double)0.0, (double)10.5, (double)6.0, (double)5.0, (double)12.5), KegBlock.box((double)10.0, (double)0.0, (double)10.5, (double)12.0, (double)5.0, (double)12.5), KegBlock.box((double)6.0, (double)1.5, (double)11.0, (double)10.0, (double)3.5, (double)12.0), KegBlock.box((double)2.5, (double)5.0, (double)3.5, (double)13.5, (double)9.0, (double)5.5), KegBlock.box((double)4.0, (double)0.0, (double)3.5, (double)6.0, (double)5.0, (double)5.5), KegBlock.box((double)10.0, (double)0.0, (double)3.5, (double)12.0, (double)5.0, (double)5.5), KegBlock.box((double)6.0, (double)1.5, (double)4.0, (double)10.0, (double)3.5, (double)5.0)});

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.Z ? Z_AXIS_SHAPE : X_AXIS_SHAPE;
    }

    public KegBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(PotionItems.MUG)) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            player.addItem(PotionItems.ALE.toStack());
            if (!player.hasInfiniteMaterials()) {
                stack.shrink(1);
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected MapCodec<KegBlock> codec() {
        return CODEC;
    }
}

