/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.block.functional.network.PathService;
import org.confluence.mod.common.item.common.WireCutterItem;
import org.confluence.mod.common.item.common.WrenchItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface INetworkBlock {
    default public void onNodeRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState pNewState) {
        BlockEntity blockEntity;
        if (!level.isClientSide && !state.is(pNewState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof INetworkEntity) {
            INetworkEntity entity = (INetworkEntity)blockEntity;
            PathService.INSTANCE.onBlockEntityUnload(entity);
            for (Int2ObjectMap.Entry entry : entity.getRelativePoses().int2ObjectEntrySet()) {
                int color = entry.getIntKey();
                for (BlockPos blockPos : (Set)entry.getValue()) {
                    INetworkEntity entity1;
                    Set posSet;
                    BlockEntity blockEntity2 = level.getBlockEntity(blockPos);
                    if (!(blockEntity2 instanceof INetworkEntity) || (posSet = (Set)(entity1 = (INetworkEntity)blockEntity2).getConnectedPoses().get(color)) == null) continue;
                    posSet.remove(pos);
                    if (posSet.isEmpty()) {
                        entity1.getConnectedPoses().remove(color);
                    }
                    entity1.markUpdated();
                }
            }
        }
    }

    default public void execute(BlockState state, ServerLevel level, BlockPos pos, boolean hasSignal) {
        this.execute(state, level, pos, -1, hasSignal);
    }

    default public void execute(BlockState state, ServerLevel level, BlockPos pos, int color, boolean hasSignal) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof INetworkEntity) {
            INetworkEntity entity = (INetworkEntity)blockEntity;
            if (color == -1) {
                entity.getOrCreateNetworkNode().getNetworks().values().stream().filter(network -> hasSignal != network.hasSignal()).peek(network -> network.setSignal(hasSignal)).flatMap(network -> network.getNodes().stream().map(networkNode -> new Tuple((Object)network.getColor(), (Object)networkNode.getEntity()))).collect(Collectors.toSet()).forEach(tuple -> INetworkBlock.internalExecute(level, pos, (Integer)tuple.getA(), hasSignal, (INetworkEntity)tuple.getB()));
            } else {
                Network network2 = entity.getOrCreateNetworkNode().getNetwork(color);
                if (network2 != null && hasSignal != network2.hasSignal()) {
                    network2.setSignal(hasSignal);
                    network2.getNodes().stream().map(NetworkNode::getEntity).collect(Collectors.toSet()).forEach(entity1 -> INetworkBlock.internalExecute(level, pos, color, hasSignal, entity1));
                }
            }
            if (hasSignal) {
                this.onExecute(state, level, pos, color, entity);
            } else {
                this.onUnExecute(state, level, pos, color, entity);
            }
        }
    }

    public static void internalExecute(ServerLevel level, @Nullable BlockPos pos, int color, boolean hasSignal, INetworkEntity networkEntity) {
        if (level == null) {
            return;
        }
        BlockState blockState = networkEntity.getSelf().getBlockState();
        BlockPos blockPos = networkEntity.getSelf().getBlockPos();
        if (blockPos.equals((Object)pos)) {
            return;
        }
        Block block = blockState.getBlock();
        if (block instanceof INetworkBlock) {
            INetworkBlock block2 = (INetworkBlock)block;
            if (hasSignal) {
                block2.onExecute(blockState, level, blockPos, color, networkEntity);
            } else {
                block2.onUnExecute(blockState, level, blockPos, color, networkEntity);
            }
        }
    }

    public void onExecute(BlockState var1, ServerLevel var2, BlockPos var3, int var4, INetworkEntity var5);

    default public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
    }

    default public boolean skipInteraction(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return item instanceof WrenchItem || item instanceof WireCutterItem;
    }
}

