/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.block.functional.network.PathService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface INetworkEntity {
    public BlockEntity getSelf();

    public void setNetworkNode(NetworkNode var1);

    @Nullable
    public NetworkNode getNetworkNode();

    public Int2ObjectMap<Set<BlockPos>> getConnectedPoses();

    public Int2ObjectMap<Set<BlockPos>> getRelativePoses();

    default public void markUpdated() {
        BlockEntity self = this.getSelf();
        self.setChanged();
        if (self.getLevel() != null) {
            self.getLevel().sendBlockUpdated(self.getBlockPos(), self.getBlockState(), self.getBlockState(), 2);
        }
    }

    default public void onNodeLoad() {
        if (this.getSelf().getLevel() != null && !this.getSelf().getLevel().isClientSide) {
            PathService.INSTANCE.onBlockEntityLoad(this);
        }
    }

    default public void onNodeUnload() {
        if (this.getSelf().getLevel() != null && !this.getSelf().getLevel().isClientSide) {
            PathService.INSTANCE.onBlockEntityUnload(this);
        }
    }

    default public void deserializePoses(@NotNull CompoundTag nbt, String posesKey, Int2ObjectMap<Set<BlockPos>> map) {
        map.clear();
        CompoundTag compoundTag = nbt.getCompound(posesKey);
        for (String key : compoundTag.getAllKeys()) {
            ListTag listTag = compoundTag.getList(key, 10);
            int color = Integer.parseInt(key);
            HashSet posSet = new HashSet();
            listTag.forEach(tag -> {
                BlockPos offset = NbtUtils.readBlockPos((CompoundTag)((CompoundTag)tag), (String)"offset").orElse(BlockPos.ZERO);
                posSet.add(this.getSelf().getBlockPos().offset(offset.getX(), offset.getY(), offset.getZ()));
            });
            map.put(color, posSet);
        }
    }

    default public CompoundTag serializePoses(CompoundTag nbt, String posesKey, Int2ObjectMap<Set<BlockPos>> map) {
        CompoundTag compoundTag = new CompoundTag();
        for (Int2ObjectMap.Entry entry : map.int2ObjectEntrySet()) {
            ListTag listTag = new ListTag();
            for (BlockPos blockPos : (Set)entry.getValue()) {
                BlockPos offset = blockPos.subtract((Vec3i)this.getSelf().getBlockPos());
                CompoundTag tag = new CompoundTag();
                tag.put("offset", NbtUtils.writeBlockPos((BlockPos)offset));
                listTag.add((Object)tag);
            }
            compoundTag.put(String.valueOf(entry.getIntKey()), (Tag)listTag);
        }
        nbt.put(posesKey, (Tag)compoundTag);
        return nbt;
    }

    default public NetworkNode getOrCreateNetworkNode() {
        if (this.getNetworkNode() == null) {
            PathService.INSTANCE.onBlockEntityLoad(this);
        }
        return this.getNetworkNode();
    }

    default public void connectTo(int color, BlockPos relatedPos, INetworkEntity related) {
        if (relatedPos.equals((Object)this.getSelf().getBlockPos()) || !relatedPos.equals((Object)related.getSelf().getBlockPos())) {
            return;
        }
        Set posSet = (Set)this.getConnectedPoses().computeIfAbsent(color, i -> new HashSet());
        if (!posSet.contains(relatedPos)) {
            posSet.add(relatedPos);
            this.markUpdated();
        }
        if (!(posSet = (Set)related.getRelativePoses().computeIfAbsent(color, i -> new HashSet())).contains(this.getSelf().getBlockPos())) {
            posSet.add(this.getSelf().getBlockPos());
            related.markUpdated();
        }
    }

    default public void disconnectWith(int color, BlockPos relatedPos, INetworkEntity related) {
        if (relatedPos.equals((Object)this.getSelf().getBlockPos()) || !relatedPos.equals((Object)related.getSelf().getBlockPos())) {
            return;
        }
        Set posSet = (Set)this.getConnectedPoses().get(color);
        if (posSet != null) {
            posSet.remove(relatedPos);
            if (posSet.isEmpty()) {
                this.getConnectedPoses().remove(color);
            }
            this.markUpdated();
        }
        if ((posSet = (Set)related.getRelativePoses().get(color)) != null) {
            posSet.remove(this.getSelf().getBlockPos());
            if (posSet.isEmpty()) {
                related.getRelativePoses().remove(color);
            }
            related.markUpdated();
        }
    }
}

