/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkService;

public class NetworkNode {
    private final int id;
    private final Int2ObjectMap<Network> networks;
    private final INetworkEntity blockEntity;
    boolean inQueue;
    boolean cachedSignal;

    public NetworkNode(int id, INetworkEntity blockEntity) {
        this.id = id;
        this.blockEntity = blockEntity;
        this.networks = new Int2ObjectOpenHashMap();
        this.inQueue = false;
        this.cachedSignal = false;
    }

    public int getId() {
        return this.id;
    }

    public Network getNetwork(int color) {
        return (Network)this.networks.get(color);
    }

    public Network getOrCreateNetwork(int color) {
        Network network = (Network)this.networks.get(color);
        if (network == null) {
            Network network1 = NetworkService.INSTANCE.createNetwork(color);
            network1.setSignal(this.cachedSignal);
            NetworkService.INSTANCE.addNodeToNetwork(this, network1);
            return network1;
        }
        return network;
    }

    public Int2ObjectMap<Network> getNetworks() {
        return this.networks;
    }

    public void removeNetwork(int color) {
        this.networks.remove(color);
    }

    public void addNetwork(Network network) {
        this.networks.put(network.getColor(), (Object)network);
    }

    public BlockPos getPos() {
        return this.blockEntity.getSelf().getBlockPos();
    }

    public BlockState getState() {
        return this.blockEntity.getSelf().getBlockState();
    }

    public INetworkEntity getEntity() {
        return this.blockEntity;
    }

    public boolean hasSignal() {
        return this.networks.values().stream().anyMatch(Network::hasSignal);
    }

    public boolean hasSignal(BlockPos blockPos) {
        return this.networks.values().stream().flatMap(network -> network.getNodes().stream()).anyMatch(networkNode -> {
            BlockState blockState = networkNode.getState();
            return !networkNode.getPos().equals((Object)blockPos) && blockState.hasProperty((Property)StateProperties.SIGNAL) && (Boolean)blockState.getValue((Property)StateProperties.SIGNAL) != false;
        });
    }
}

