/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.network;

import java.util.HashSet;
import java.util.Set;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.mesdag.particlestorm.api.IntAllocator;

public class NetworkService {
    private IntAllocator nodeID = new IntAllocator();
    private Set<Network> networks = new HashSet<Network>();
    public static final NetworkService INSTANCE = new NetworkService();

    public void onServerStart() {
        this.nodeID = new IntAllocator();
        this.networks = new HashSet<Network>();
    }

    public void onServerStop() {
        this.nodeID.clear();
        this.networks.clear();
    }

    public Network createNetwork(int color) {
        Network network = new Network(color);
        this.networks.add(network);
        return network;
    }

    public void createNetworkNode(INetworkEntity blockEntity) {
        NetworkNode node = new NetworkNode(this.nodeID.allocate(), blockEntity);
        blockEntity.setNetworkNode(node);
    }

    public void removeNetwork(Network network) {
        this.networks.remove(network);
        network.destroy();
    }

    public void removeNetworkNode(NetworkNode node) {
        this.nodeID.release(node.getId());
    }

    public void addNodeToNetwork(NetworkNode node, Network network) {
        network.addNode(node);
        node.addNetwork(network);
    }

    public void removeNodeInNetwork(NetworkNode node, Network network) {
        network.removeNode(node);
        node.removeNetwork(network.getColor());
    }

    public Set<Network> getNetworks() {
        return this.networks;
    }

    public void mergeNetwork(Network n1, Network n2) {
        Network n3 = Network.merge(n1, n2);
        n3.setSignal(n1.hasSignal() || n2.hasSignal());
        if (n3 == n1) {
            this.removeNetwork(n2);
        } else {
            this.removeNetwork(n1);
        }
    }
}

