/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.block.functional.network.NetworkService;

public class PathService {
    public static final PathService INSTANCE = new PathService();
    private Queue<NetworkNode> queue;

    public void onServerStart() {
        this.queue = new ArrayDeque<NetworkNode>();
    }

    public void onServerStop() {
        this.queue = null;
    }

    public void onBlockEntityLoad(INetworkEntity blockEntity) {
        NetworkService.INSTANCE.createNetworkNode(blockEntity);
        this.addToQueue(blockEntity);
    }

    public void onBlockEntityUnload(INetworkEntity blockEntity) {
        NetworkNode networkNode = blockEntity.getNetworkNode();
        if (networkNode == null) {
            return;
        }
        for (Network network : networkNode.getNetworks().values()) {
            for (NetworkNode node : network.getNodes()) {
                if (node.inQueue) continue;
                node.inQueue = true;
                node.cachedSignal = network.hasSignal();
                this.queue.add(node);
            }
            NetworkService.INSTANCE.removeNodeInNetwork(networkNode, network);
            NetworkService.INSTANCE.removeNetwork(network);
        }
        NetworkService.INSTANCE.removeNetworkNode(networkNode);
    }

    public void addToQueue(INetworkEntity blockEntity) {
        this.queue.add(blockEntity.getOrCreateNetworkNode());
    }

    public void pathFindingTick() {
        if (this.queue == null) {
            return;
        }
        boolean flag = false;
        while (!this.queue.isEmpty()) {
            ServerLevel level;
            flag = true;
            NetworkNode cur = this.queue.remove();
            cur.inQueue = false;
            INetworkEntity entity2 = cur.getEntity();
            Level level2 = entity2.getSelf().getLevel();
            if (!(level2 instanceof ServerLevel) || !(level = (ServerLevel)level2).isLoaded(cur.getPos()) || entity2.getSelf().isRemoved()) continue;
            ServerChunkCache chunkSource = level.getChunkSource();
            for (Int2ObjectMap.Entry entry1 : entity2.getConnectedPoses().int2ObjectEntrySet()) {
                int color = entry1.getIntKey();
                Iterator iterator = ((Set)entry1.getValue()).iterator();
                while (iterator.hasNext()) {
                    BlockPos pos = (BlockPos)iterator.next();
                    ChunkAccess chunk = LibUtils.getChunkIfLoaded((ServerChunkCache)chunkSource, (BlockPos)pos);
                    if (chunk == null) continue;
                    Network curNetwork = null;
                    BlockEntity blockEntity = chunk.getBlockEntity(pos);
                    if (blockEntity instanceof INetworkEntity) {
                        INetworkEntity blockEntity2 = (INetworkEntity)blockEntity;
                        curNetwork = cur.getOrCreateNetwork(color);
                        NetworkNode next = blockEntity2.getOrCreateNetworkNode();
                        Network nextNetwork = next.getNetwork(color);
                        if (nextNetwork == null) {
                            NetworkService.INSTANCE.addNodeToNetwork(next, curNetwork);
                            this.queue.add(next);
                        } else if (curNetwork != nextNetwork) {
                            NetworkService.INSTANCE.mergeNetwork(curNetwork, nextNetwork);
                            curNetwork = cur.getNetwork(color);
                        }
                    } else {
                        iterator.remove();
                        Network network = cur.getNetwork(color);
                        if (network != null) {
                            this.queue.addAll(network.getNodes());
                        }
                    }
                    if (curNetwork == null) continue;
                    cur.cachedSignal = curNetwork.calculateSignal();
                    curNetwork.schedule = true;
                }
                if (!((Set)entry1.getValue()).isEmpty()) continue;
                entity2.getConnectedPoses().remove(color);
            }
        }
        if (flag) {
            for (Network network : NetworkService.INSTANCE.getNetworks()) {
                if (!network.schedule) continue;
                network.schedule = false;
                network.getNodes().stream().filter(node -> node.cachedSignal != network.hasSignal()).map(NetworkNode::getEntity).collect(Collectors.toSet()).forEach(entity -> INetworkBlock.internalExecute((ServerLevel)entity.getSelf().getLevel(), null, -1, network.hasSignal(), entity));
            }
        }
    }
}

