/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.data.saved.KillBoard;

public class BasePlantBlock
extends BushBlock {
    public static final MapCodec<BasePlantBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BasePlantBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("ground").forGetter(block -> block.survive)).apply((Applicative)instance, BasePlantBlock::new));
    protected static final VoxelShape SHAPE = BasePlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected final List<Block> survive;
    private transient Set<Block> cache;

    public BasePlantBlock(Block ... survive) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).replaceable(), Arrays.stream(survive).toList());
    }

    public BasePlantBlock(BlockBehaviour.Properties prop, List<Block> survive) {
        super(prop);
        this.survive = survive;
    }

    protected MapCodec<BasePlantBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(level, pos);
        return SHAPE.move(offset.x, offset.y, offset.z);
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.cache == null) {
            this.cache = new HashSet<Block>(this.survive);
        }
        return this.cache.contains(state.getBlock());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        return this.mayPlaceOn(belowState, (BlockGetter)level, below);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (this.canSurvive(this.defaultBlockState(), (LevelReader)level, pos)) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState updateShape(BlockState originState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        ISpreadable.Type type;
        BlockState after = super.updateShape(originState, facing, facingState, level, currentPos, facingPos);
        if (facing != Direction.DOWN) {
            return after;
        }
        Block block = facingState.getBlock();
        if (block instanceof ISpreadable) {
            ISpreadable sp = (ISpreadable)block;
            type = sp.getSpreadType();
        } else {
            type = ISpreadable.Type.PURE;
        }
        ISpreadable.Type type2 = type;
        BlockState transformResult = type2.getNotNull(originState, KillBoard.INSTANCE.getGamePhase().isHardmode());
        return transformResult.canSurvive((LevelReader)level, currentPos) ? transformResult : Blocks.AIR.defaultBlockState();
    }
}

