/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.confluence.lib.util.LibUtils;

public class BranchesBlock
extends PipeBlock {
    public static final MapCodec<BranchesBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("attachable").forGetter(block -> block.attachable), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("supporting").forGetter(block -> block.supporting)).apply((Applicative)instance, BranchesBlock::new));
    public static final int DECAY_DISTANCE = 12;
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)1, (int)12);
    protected final TagKey<Block> attachable;
    protected final TagKey<Block> supporting;

    public BranchesBlock(TagKey<Block> attachable, TagKey<Block> supporting) {
        super(0.1875f, BlockBehaviour.Properties.of().instabreak().sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(12))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        this.attachable = attachable;
        this.supporting = supporting;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState dest = this.defaultBlockState();
        BlockState belowState = level.getBlockState(pos.below());
        boolean belowIsThis = belowState.is((Block)this);
        for (Direction direction : LibUtils.DIRECTIONS) {
            BlockPos relative = pos.relative(direction);
            BlockState relativeState = level.getBlockState(relative);
            boolean shouldConnect = relativeState.is((Block)this) || relativeState.is(this.attachable) || direction == Direction.DOWN && relativeState.is(this.supporting);
            BlockState relativeBelowState = level.getBlockState(relative.below());
            shouldConnect &= !relativeBelowState.is((Block)this) || (Boolean)relativeBelowState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite())) == false;
            BooleanProperty dirProp = (BooleanProperty)PROPERTY_BY_DIRECTION.get(direction);
            if (belowIsThis) {
                shouldConnect &= ((Boolean)belowState.getValue((Property)dirProp)).booleanValue();
            }
            dest = (BlockState)dest.trySetValue((Property)dirProp, (Comparable)Boolean.valueOf(shouldConnect));
        }
        return this.updateDistance(dest, (LevelAccessor)level, pos);
    }

    private BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 12;
        int value = (Integer)state.getValue((Property)DISTANCE);
        for (Direction direction : LibUtils.DIRECTIONS) {
            int distanceAt;
            if (direction != Direction.UP && (distanceAt = this.getDistanceAt(level.getBlockState(pos.relative(direction)), direction)) < value && (i = Math.min(i, distanceAt + 1)) == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private int getDistanceAt(BlockState neighbor, Direction direction) {
        if (neighbor.is(this.attachable) || direction == Direction.DOWN && neighbor.is(this.supporting)) {
            return 0;
        }
        return neighbor.hasProperty((Property)DISTANCE) ? (Integer)neighbor.getValue((Property)DISTANCE) : 12;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = this.updateDistance(state, level, currentPos);
        if (!newState.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
            return super.updateShape(newState, facing, facingState, level, currentPos, facingPos);
        }
        if (facing.getAxis().isVertical() || !level.getBlockState(facingPos.below()).is((Block)this)) {
            boolean flag = facingState.is((Block)this) || facingState.is(this.attachable) || facing == Direction.DOWN && facingState.is(this.supporting);
            return (BlockState)newState.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(flag));
        }
        return newState;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)DISTANCE) == 12 && !state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        if (stateBelow.is((Block)this) || stateBelow.is(this.supporting)) {
            return true;
        }
        int value = (Integer)state.getValue((Property)DISTANCE);
        if (value == 1) {
            return true;
        }
        for (Direction direction : LibUtils.HORIZONTAL) {
            BlockState stateAtSide = level.getBlockState(pos.relative(direction));
            int distanceAt = this.getDistanceAt(stateAtSide, direction);
            if (distanceAt >= value && !stateAtSide.is(this.attachable)) continue;
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<BranchesBlock> codec() {
        return CODEC;
    }
}

