/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.ModTags;

public class CattailBlock
extends Block
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final EnumProperty<CattailPart> PART = EnumProperty.create((String)"part", CattailPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty AIR_HEIGHT = IntegerProperty.create((String)"air_height", (int)0, (int)3);
    public static final IntegerProperty MAX_AIR_HEIGHT = IntegerProperty.create((String)"max_air_height", (int)1, (int)3);
    protected static final VoxelShape SHAPE = CattailBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape TOP_SHAPE = CattailBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public CattailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)CattailPart.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AIR_HEIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)MAX_AIR_HEIGHT, (Comparable)Integer.valueOf(3)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, WATERLOGGED, AIR_HEIGHT, MAX_AIR_HEIGHT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(PART) == CattailPart.TOP ? TOP_SHAPE : SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluid = level.getFluidState(pos);
        BlockState below = level.getBlockState(pos.below());
        if (below.is((Block)this)) {
            int maxHeight;
            boolean emerging = (Boolean)below.getValue((Property)WATERLOGGED) != false && !fluid.is(FluidTags.WATER);
            int n = maxHeight = emerging ? level.random.nextInt(1, 4) : ((Integer)below.getValue((Property)MAX_AIR_HEIGHT)).intValue();
            int rawHeight = emerging ? 1 : (fluid.is(FluidTags.WATER) ? 0 : (Integer)below.getValue((Property)AIR_HEIGHT) + 1);
            int safeHeight = Math.min(rawHeight, 3);
            return this.getCattailState(fluid.is(FluidTags.WATER), safeHeight, maxHeight);
        }
        if (fluid.is(FluidTags.WATER) && below.isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP) && below.is(ModTags.Blocks.CATTAIL_CAN_SURVIVE)) {
            return this.getCattailState(true, 0, 1);
        }
        return null;
    }

    private BlockState getCattailState(boolean waterlogged, int airHeight, int maxAirHeight) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)AIR_HEIGHT, (Comparable)Integer.valueOf(airHeight))).setValue((Property)MAX_AIR_HEIGHT, (Comparable)Integer.valueOf(maxAirHeight))).setValue(PART, (Comparable)((Object)CattailPart.TOP));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.getValue(PART) == CattailPart.TOP && (Integer)state.getValue((Property)AIR_HEIGHT) < (Integer)state.getValue((Property)MAX_AIR_HEIGHT) && random.nextFloat() < 0.15f) {
            this.grow(level, pos, 1);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        if (!belowState.is((Block)this)) {
            return level.getFluidState(pos).is(FluidTags.WATER) && belowState.isFaceSturdy((BlockGetter)level, below, Direction.UP) && belowState.is(ModTags.Blocks.CATTAIL_CAN_SURVIVE);
        }
        return true;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide() && !oldState.is(state.getBlock())) {
            BlockState updatedState = state.updateShape(Direction.UP, level.getBlockState(pos.above()), (LevelAccessor)level, pos, pos.above());
            if (updatedState != state) {
                level.setBlock(pos, updatedState, 3);
            }
            level.neighborChanged(pos.above(), (Block)this, pos);
            level.neighborChanged(pos.below(), (Block)this, pos);
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facing == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.UP) {
            if (facingState.is((Block)this)) {
                if (state.getValue(PART) == CattailPart.TOP) {
                    CattailPart bodyPart = (Boolean)state.getValue((Property)WATERLOGGED) != false ? CattailPart.SUBMERGED : ((Integer)state.getValue((Property)AIR_HEIGHT) == 1 ? CattailPart.TRANSITION : CattailPart.STEM);
                    state = (BlockState)state.setValue(PART, (Comparable)((Object)bodyPart));
                }
            } else if (facingState.isAir() || !facingState.is((Block)this)) {
                state = (BlockState)state.setValue(PART, (Comparable)((Object)CattailPart.TOP));
            }
        }
        if (facing.getAxis() == Direction.Axis.Y && facingState.is((Block)this)) {
            state = (BlockState)state.setValue((Property)MAX_AIR_HEIGHT, (Comparable)((Integer)facingState.getValue((Property)MAX_AIR_HEIGHT)));
        }
        return state;
    }

    private void grow(ServerLevel level, BlockPos pos, int steps) {
        BlockPos above;
        BlockPos.MutableBlockPos buildPos = pos.mutable();
        while (buildPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(buildPos.above()).is((Block)this)) {
            buildPos.move(Direction.UP);
        }
        BlockState currentTop = level.getBlockState((BlockPos)buildPos);
        int currentAirH = (Integer)currentTop.getValue((Property)AIR_HEIGHT);
        int maxH = (Integer)currentTop.getValue((Property)MAX_AIR_HEIGHT);
        for (int i = 0; i < steps && (above = buildPos.above()).getY() < level.getMaxBuildHeight(); ++i) {
            FluidState fluidAbove = level.getFluidState(above);
            boolean isWater = fluidAbove.is(FluidTags.WATER);
            if (!isWater) {
                if (currentAirH == 0) {
                    maxH = level.random.nextInt(1, 4);
                }
                if (!level.isEmptyBlock(above) || currentAirH >= maxH) break;
            }
            buildPos.move(Direction.UP);
            if (!isWater) {
                currentAirH = Math.min(currentAirH + 1, 3);
            }
            level.setBlock((BlockPos)buildPos, this.getCattailState(isWater, isWater ? 0 : currentAirH, maxH), 3);
            if (!isWater) break;
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos topPos = pos.mutable();
        while (level.getBlockState(topPos.above()).is((Block)this)) {
            topPos.move(Direction.UP);
        }
        BlockState topState = level.getBlockState((BlockPos)topPos);
        return (Integer)topState.getValue((Property)AIR_HEIGHT) < (Integer)topState.getValue((Property)MAX_AIR_HEIGHT);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.grow(level, pos, random.nextInt(2, 4));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static enum CattailPart implements StringRepresentable
    {
        SUBMERGED("submerged"),
        TRANSITION("transition"),
        STEM("stem"),
        TOP("top");

        private final String name;

        private CattailPart(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

